<?php

namespace App\Http\Resources\AdminDashboard\EducationalOffice;

use App\Http\Resources\AdminDashboard\EducationalDepartment\EducationalDepartmentResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EducationalOfficeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=> $this->id,
            'name'=> $this->name,
            'department'=>  new EducationalDepartmentResource($this->Department),
            'status'=>($this->status == 1)?trans('api.active'):trans('api.inactive'),  
        ];
    }
}
