<?php

namespace App\Http\Resources\AdminDashboard\Coupons;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CouponUsageHistoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'subscription_id' => $this->id,
            'order_number' => $this->order_number,
            'user' =>  $this->user->name,
            'coupon_discount' =>  $this->coupon_discount,
            'total_before_discount' => $this->subscription_fee,
            'total_price' => $this->total_price,
        ];

    }
}
