<?php

namespace App\Http\Requests\Slider;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class SliderStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
 public function rules(Request $request)
    {
        return[
            'text' => 'required|string',
            'image' => 'required',
            'start_date' => 'required',
            'end_date' => 'required',
            'start_date_type' => 'required|string|in:coptic,hijri',
            'end_date_type' => 'required|string|in:coptic,hijri',
        ];
        
    }
    

}
