<?php

namespace App\Http\Requests\School;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\SchoolSemesterVacation;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;

class SchoolSemesterVacationUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
 public function rules(Request $request)
    {
        $date = $this->date; // The date is already formatted in prepareForValidation()
        
        // Check if the date falls within any valid semester
        $semester = SchoolSemester::whereRaw('STR_TO_DATE(start_date, "%d/%m/%Y") <= ?', [$date])
        ->whereRaw('STR_TO_DATE(end_date, "%d/%m/%Y") >= ?', [$date])
        ->first();
        

        if (!$semester) {
            
            throw ValidationException::withMessages([
                'date' => trans('validation.The selected date does not fall within any valid semester.')
            ]);
        }

        // If semester is found, define the validation rules
        $start_date = \Carbon\Carbon::createFromFormat('d/m/Y', $semester->start_date)->format('Y-m-d');
        $end_date = \Carbon\Carbon::createFromFormat('d/m/Y', $semester->end_date)->format('Y-m-d');

        return [
            'vacation_id' => 'exists:semester_vacations,id',
            'date_type' => 'required|in:hijri,coptic',
            'date' => [
                "required",
                "after_or_equal:$start_date",
                "before_or_equal:$end_date",
            ],
        ];

        // if($vacation) {
        //     $start_date = \Carbon\Carbon::createFromFormat('d/m/Y',$vacation->semester->start_date)->format('Y-m-d');
        //     $end_date = \Carbon\Carbon::createFromFormat('d/m/Y',$vacation->semester->end_date)->format('Y-m-d');
        // }

        // $rules = [
        //     'date_type' => 'required|in:hijri,coptic',
        // ];
        // if($vacation) {
        //     $rules = array_merge($rules, [
        //         'date' => [
        //             "required",
        //             "after_or_equal:$start_date",
        //             "before_or_equal:$end_date"
        //         ]
        //     ]);
        // }
    }

    protected function prepareForValidation()
    {
        $date = $this->date;
        if (isset($this->date_type) && isset($this->date)) {
            if ($this->date_type == "hijri") {
                $date = Helper::getCoptic($this->date);
            }
        }
        
        $this->merge([
            'date' => \Carbon\Carbon::createFromFormat('d/m/Y', $this->date)->format('Y-m-d'),
        ]);
    }


}
