<?php

namespace App\Http\Requests\ManagerDashboard\waitingPeriodsSchedule;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class WaitingPeriodsScheduleDataRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        return [
            'data' => ['required', 'array'],
            'data.*.school_employee_id' => 'required|integer|exists:school_employees,id',          
            'data.*.class_name_id' => 'required|integer|exists:class_names,id',
            'data.*.class_number' => 'required|integer',
            'data.*.subject_id' => 'required|integer|exists:subjects,id',
            'data.*.period_id' => 'required|integer|exists:periods,id',
        ];
    }
}
