<?php

namespace App\Http\Requests\ManagerDashboard\TeamAndCommitteeMeetings;

use App\Helpers\Helper;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class MeetingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return[
            'name' => 'required|string|max:150',
            'model_type' =>['in:committees,teams'],
            'model_id' =>['required'],
            'school_id' => ['required','exists:schools,id'],
            'meeting_type' =>['in:urgent,periodic'],
            'date' =>['required'],
            'date_type' =>['in:hijri,coptic'],
            'start_time' =>['required'],
            'place' => 'required|string|max:100',
        ];
    }

    protected function prepareForValidation()
    {
        $date = $this->date;
        if (isset($this->date_type) && isset($this->date)) {
            if ($this->date_type == "hijri") {
                $date = Helper::getCoptic($this->date);
            }
        }
        
        $this->merge([
            'date' => \Carbon\Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d'),
        ]);
    }

}
