<?php

namespace App\Http\Requests\ManagerDashboard\Proceed;

use App\Rules\DateWithinSemester;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class ProceedStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
 public function rules(Request $request)
    {
        $rules =[
            'title' => 'required|string',
            'text' => 'required|string',
            'date' => ['required', 'string', new DateWithinSemester($request->input('date_type'))],
            'date_type' => 'required|string|in:coptic,hijri',
            'proceed_type' => 'required|string|in:destruction,loss,incident,general',
        ];
        if ($request->proceed_type == 'general' || $request->proceed_type == 'incident') {
            $rules['employes_ids'] = 'required|array';
        }
        return $rules;
        
    }

}
