<?php

namespace App\Http\Requests\ManagerDashboard\Namazeg;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class ReportClassPlanActivityStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'n_medical_sessions' => 'required|string',
            'percent_medical_sessions' => 'required|string',
            'n_ernrichment_sessions' => 'required|string',
            'percent_ernrichment_sessions' => 'required|string',
            'employee_ids' => 'required|array',
            'employee_ids.*' => 'required|exists:school_employees,id',
            'difficulty' => 'required|string',
            'challenges' => 'required|string',
            'solutions' => 'required|string',
            'suggestions' => 'required|string',
            'date' => 'required|string',
            'date_type' => 'required|in:coptic,hijri',
        ];
        return $rules;
    }
}
