<?php

namespace App\Http\Requests\ManagerDashboard\Namazeg;

use App\Rules\DateWithinSemester;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class QuestioningStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'date' => ['required', 'string', new DateWithinSemester($request->input('date_type'))],
            'date_type' => 'required|in:hijri,coptic',
            'employee_id' => 'required|exists:school_employees,id',
            'details' => 'required|array',
            'details.*' => 'required|string',
        ];
        return $rules;
    }
}
