<?php

namespace App\Http\Requests\ManagerDashboard\Namazeg;

use App\Rules\DateWithinSemester;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class BooksDeliveryStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'date' => ['required', 'string', new DateWithinSemester($request->input('date_type'))],
            'date_type' => 'required|string|in:coptic,hijri',
            'type' => 'required|in:all_classes,class_id,school_class_id',
        ];
        if ($request->type == "class_id") {
            $rules['type_value'] = 'required|exists:class_names,id';
        } elseif ($request->type == "school_class_id") {
            $rules['type_value'] = 'required|exists:school_classes,id';
        } 
        return $rules;
    }
}
