<?php

namespace App\Http\Requests\ManagerDashboard\Namazeg;

use App\Rules\DateWithinSemester;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class AssignProfessionalCommunitiesStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        $rules = [
            'date' => ['required', 'string', new DateWithinSemester($request->input('date_type'))],
            'date_type' => 'required|in:hijri,coptic',
            'start_date' => 'required|string',
            'start_date_type' => 'required|in:hijri,coptic',
            'specialize_id' => 'required|string|exists:specializations,id',
            'data' => 'required|array',
            'data.*.employee_id' => 'required|exists:school_employees,id',
            'data.*.assignment_details' => 'required|string',
            'data.*.class_teaching' => 'required|string',
        ];
        return $rules;
    }
}
