<?php

namespace App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\MonitorDailyObservers;

use Illuminate\Foundation\Http\FormRequest;

class UpdateMonitorDailyObserverRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'data.committee_id' => ['exists:exams_student_committees_table,id'],
            'data.subject_id' => ['exists:subjects,id'],
            'data.exam_time' => ['nullable'],
            'data.employees_ids' => 'nullable|array',
            'data.employees_ids.*' => 'integer|exists:school_employees,id',
        ];
    }
}
