<?php

namespace App\Http\Requests\ManagerDashboard\Circulars;

use App\Helpers\Helper;
use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class InternalCircularRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        return [
            'school_id' => 'required|integer|exists:schools,id',
            'title' => 'required|string|max:255',
            'details' => 'required|string',
            'date' => 'required',
            'date_type' => 'required|string',
            'day' => 'required|string',
            'teachers' => 'required|array',
            'teachers.*' => ['integer', Rule::exists('school_employees', 'id')],
        ];
    }

    protected function prepareForValidation()
    {
        $date = $this->date;
        if (isset($this->date_type) && isset($this->date)) {
            if ($this->date_type == "hijri") {
                $date = Helper::getCoptic($this->date);
            }
        }
        
        $this->merge([
            'date' => \Carbon\Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d'),
        ]);
    }

}
