<?php

namespace App\Http\Requests\ManagerDashboard\Assignments;

use App\Rules\DateWithinSemester;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class GeneralAssignmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(Request $request): array
    {
        return [
            'date' => ['required',new DateWithinSemester($request->input('date_type'))],
            'date_type' => 'required|string|in:coptic,hijri',
            'duration_id' => 'required|integer|exists:assignment_general_durations,id', 
            'details' => 'nullable|string',
            'employees' => 'required|array',
            'employees.*' => 'required|integer|exists:school_employees,id',
        ];
    }
}
