<?php

namespace App\Http\Requests\AdminDashboard\Procedures;

use Illuminate\Foundation\Http\FormRequest;

class StoreAbsenceProcedureRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name_id' => ['required','integer','exists:procedure_names,id'],
            'absence_form_id' => ['required', 'array'],
            'absence_form_id.*' => ['required', 'exists:namazeg,id'],
            'absence_dayes' => ['required','integer'],
            'status' =>['nullable','in:1,0'],
            'details'=>['nullable'],
        ];
    }

    public function messages()
    {
        return [
            'name_id.required' => 'حقل الاسم مطلوب.',
            'name.string' => 'يجب أن يكون الاسم نصًا.',
            'name.min' => 'يجب ألا يقل الاسم 3 حرفًا.',
            'name.max' => 'يجب ألا يتجاوز الاسم 255 حرفًا.',
            'absence_dayes.required' => 'يجب تحديد عدد ايام الغياب ' ,
            'absence_dayes.integer' => 'يجب ان يكون عدد ايام الغياب رقم صحيح',
            'absence_form_id.required' => 'يجب اختيار الإجراءات المراد تطبيقها.',
            'absence_form_id.*.exists' => 'الإجراءات المراد تطبيقها غير موجودة.',
            'status.in' => 'يجيب ادخال قيمة 0 او 1',
        ];
    }
}
