<?php

namespace App\Http\Requests\AdminDashboard\ExternalSystem;

use Illuminate\Foundation\Http\FormRequest;

class UpdateExternalSystemRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['nullable','string','min:3','max:255'],
            'url'  => ['required'],
            'logo' => ['nullable','mimes:png,jpg,jpeg'],
            'description' =>['nullable'],
            'status' =>['in:1,0'],
        ];
    }


    public function messages()
    {
        return [
            'name.required' => 'حقل الاسم مطلوب.',
            'name.string' => 'يجب أن يكون الاسم نصًا.',
            'name.min' => 'يجب ألا يقل الاسم 3 حرفًا.',
            'name.max' => 'يجب ألا يتجاوز الاسم 255 حرفًا.',
            'url.required' => 'يجب ادخال الينك المطلوب',
            'logo.mimes' => 'يجب أن يكون الشعار ملف من النوع: png, jpg, jpeg فقط.',
            'status.in' => 'يجيب ادخال قيمة 0 او 1',
        ];
    }
}
