<?php

namespace App\Http\Requests\AdminDashboard\Coupons;

use Illuminate\Foundation\Http\FormRequest;

class StoreCouponRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            
            'code' => ['required', 'string','unique:coupons,code'],
            'discount_type' => ['required', 'in:percentage,fixed'],
            'discount_value' => ['required', 'numeric'],
            'coupon_status' => ['required', 'in:active,expired'],
            'expiration_date' => ['sometimes','nullable'], 
            'expiration_date_type' => ['sometimes','nullable','required_with:expiration_date','in:hijri,coptic'],
            'minimum_purchase' => ['nullable', 'numeric'],
            'maximum_purchase_limit' => ['nullable', 'numeric'], 
            'usage_status_for_users' => ['required', 'in:limited,unlimited'],
            'usage_limit_per_coupon' => ['nullable', 'numeric'], 
            'usage_status_for_user' => ['required', 'in:limited,unlimited'],
            'usage_limit_per_user' => ['nullable', 'numeric'], 
            'product_ids' => ['required','array'],
            'product_ids.*' => ['exists:products,id']
        ];
    }

    public function messages(): array
        {
            return [
                'code.required' => 'حقل الكود مطلوب.',
                'discount_type.required' => 'حقل نوع الخصم مطلوب.',
                'discount_type.in' => 'القيمة المحددة لنوع الخصم غير صالحة.',
                'discount_value.required' => 'حقل قيمة الخصم مطلوب.',
                'discount_value.numeric' => 'يجب أن تكون قيمة الخصم رقمًا.',
                'coupon_status.required' => 'حقل حالة الكوبون مطلوب.',
                'coupon_status.in' => 'القيمة المحددة لحالة الكوبون غير صالحة.',
                'expiration_date.required' => 'حقل تاريخ الانتهاء مطلوب.',
                'expiration_date.date' => 'يجب أن يكون تاريخ الانتهاء تاريخًا صحيحًا.',
                'expiration_date_type.required' => 'حقل نوع تاريخ الانتهاء مطلوب.',
                'expiration_date_type.in' => 'القيمة المحددة لنوع تاريخ الانتهاء غير صالحة.',
                'minimum_purchase.numeric' => 'يجب أن يكون الحد الأدنى للمشتريات رقمًا.',
                'maximum_purchase_limit.numeric' => 'يجب أن يكون الحد الأقصى للمشتريات رقمًا.',
                'usage_status_for_users.required' => 'حقل حالة استخدام الكوبون من قبل المستخدمين مطلوب.',
                'usage_status_for_users.in' => 'القيمة المحددة لحالة استخدام الكوبون من قبل المستخدمين غير صالحة.',
                'usage_limit_per_coupon.numeric' => 'يجب أن يكون الحد الأقصى للاستخدام لكل كوبون رقمًا.',
                'usage_status_for_user.required' => 'حقل حالة استخدام الكوبون من قبل المستخدم مطلوب.',
                'usage_status_for_user.in' => 'القيمة المحددة لحالة استخدام الكوبون من قبل المستخدم غير صالحة.',
                'usage_limit_per_user.numeric' => 'يجب أن يكون الحد الأقصى للاستخدام لكل مستخدم رقمًا.',
                'product_ids.required' => 'حقل المنتجات مطلوب  .',
                'product_ids.array' => 'حقل المنتجات يجب أن يكون مصفوفة.',
                'product_ids.*.exists' => 'بعض معرّفات المنتجات غير صحيحة.',
            ];
        }
}
