<?php

namespace App\Http\Requests\AdminDashboard\BankAccount;

use Illuminate\Foundation\Http\FormRequest;

class UpdateAccountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'bank_name' => ['sometimes','string','min:3'],
            'account_name' => ['sometimes','string','min:3'],
            'account_number' => ['sometimes','digits_between:10,20','numeric'],
            'IBAN' => ['sometimes','string'],
            'logo' => ['sometimes','mimes:png,jpg,jpeg'],
            'status' =>['sometimes','in:1,0'],

        ];
    }
}
