<?php

namespace App\Http\Middleware;

use App\Models\ManagerDashboard\Settings\Subscription;
use Auth;
use Carbon\Carbon;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckSubscription
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();

        if (!$user) {
            return response()->json(['message' => 'Unauthorized.'], 401);
        }


        if ($user->manager_id ) {

            $userSubscription = Subscription::where('user_id', $user->manager_id)
                ->where('service_type', 'system')->latest()
                ->first();

            if (!$userSubscription) {
                return response()->json(['message' => 'No active subscription found.'], 403);
            }

            try {
                $subscriptionEndDate = Carbon::createFromFormat('d/m/Y', $userSubscription->end_date);
            } catch (\Exception $e) {
                return response()->json(['message' => 'Invalid subscription date format.'], 500);
            }

            if (!$subscriptionEndDate->isFuture()) {
                $userSubscription->update(['status' => 'not_subscribed']);
                return response()->json(['message' => 'Your subscription has expired.'], 403);
            }
        }



        return $next($request);
    }
}
