<?php

namespace App\Http\Controllers\Api\School;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\School\GuideRegulationFileUpdateRequest;
use App\Http\Requests\School\GuideRegulationFileStoreRequest;
use App\Models\GuideRegulationFile;
use App\Http\Resources\School\GuideRegulationFileResource;

class GuideRegulationFileController extends Controller
{
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        //$this->middleware(['auth:api','permission:school-semesters']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request,$guide_regulation_id){
        // Start with the base query
        $data = GuideRegulationFile::query();
        
        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key,['publish_date','publish_date_type','per_page']);
        }, ARRAY_FILTER_USE_KEY);

        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\GuideRegulationFile', $filterData);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        if (isset($queryParams['publish_date_type']) && isset($queryParams['publish_date'])) {
            $publish_date = $queryParams['publish_date'];
            if ($queryParams['publish_date_type'] == "hijri") {
                $publish_date = Helper::getCoptic($queryParams['publish_date']);
            }
            $data = $data->where('publish_date', 'like', "%$publish_date%");
        }

        $filterData = GuideRegulationFileResource::collection($data->where('guide_regulation_id',$guide_regulation_id)->paginate($perPage));

        return response()->json([
            'guideAndRegulationFiles' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById(GuideRegulationFile $guideRegulationFile){
        $guideRegulationFile = new GuideRegulationFileResource($guideRegulationFile);
        return response()->json(['guideAndRegulationFile'=>$guideRegulationFile,'message'=>trans('api.guide and Regulation file details')],200);
    }

    /* this method will stord data to DB Model*/
    public function store(GuideRegulationFileStoreRequest $request){        
        $guideRegulationFile = new GuideRegulationFile();
        $guideRegulationFile->guide_regulation_id = $request->guide_regulation_id;
        $guideRegulationFile->file_name = $request->file_name;
        $guideRegulationFile->publish_date = \Carbon\Carbon::createFromFormat('Y-m-d',$request->publish_date)->format('d/m/Y');
        $guideRegulationFile->publish_date_type = 'coptic';
        if($request->hasFile('guide_regulation_file')) {
            $file_info = Helper::uploadFile('guidesRegulations',$request->guide_regulation_file);
            $guideRegulationFile->file_path = $file_info['file_name'];
            $guideRegulationFile->file_size = $file_info['file_size'];
        }
        $guideRegulationFile->save();

        return response()->json(['message'=>trans('api.record stored successflly')],200);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(GuideRegulationFileUpdateRequest $request,GuideRegulationFile $guideRegulationFile){
        $guideRegulationFile->file_name = $request->file_name;
        $guideRegulationFile->publish_date = \Carbon\Carbon::createFromFormat('Y-m-d',$request->publish_date)->format('d/m/Y');
        $guideRegulationFile->publish_date_type = 'coptic';
        
        if($request->hasFile('guide_regulation_file')) {
            $file_info = Helper::updateUploadFile('guidesRegulations',$request->guide_regulation_file,$guideRegulationFile->file_path);
            $guideRegulationFile->file_path = $file_info['file_name'];
            $guideRegulationFile->file_size = $file_info['file_size'];
        } 
        // elseif($guideRegulationFile->file_path) {
        //     $file = Helper::uploadedFilesPath('guidesRegulations',$guideRegulationFile->file_path);
        //     if(file_exists($file)) {
        //         unlink($file);
        //     }
        //     $guideRegulationFile->file_path = null;
        //     $guideRegulationFile->file_size = null;
        // }
        $guideRegulationFile->save();

        return response()->json(['message'=>trans('api.record updated successflly')],200);
    }


    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive(GuideRegulationFile $guideRegulationFile){
        $guideRegulationFile->delete();
        return response()->json(['message'=>trans('api.record archived successflly')],200);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function destroy(GuideRegulationFile $guideRegulationFile){
        $file = Helper::uploadedFilesPath('guidesRegulations',$guideRegulationFile->file_path);
        if(file_exists($file)) {
            unlink($file);
        }
        $guideRegulationFile->forceDelete();

        return response()->json(['message'=>trans('api.record deleted successflly')],200);
    }

    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore(GuideRegulationFile $guideRegulationFile){
        $guideRegulationFile->restore();
        return response()->json(['message'=>trans('api.record restored successflly')],200);
    }

    /* this method will download specific Model recored 
        by using ID
    */
    public function download(GuideRegulationFile $guideRegulationFile){

        return response()->json([
            'download_link' => $guideRegulationFile->file_path ? Helper::uploadedFilesPath('guidesRegulations',$guideRegulationFile->file_path) : null,
            'message' => trans('api.file download link'),
        ]);
    }
    
}