<?php

namespace App\Http\Controllers\Api\ManagerDashboard\TrashedRecord;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\TrashedRecordResource;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAbsenceProcedure;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAbsenceProcedureSubItem;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentLatenessProcedure;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentLatenessProcedureSubItem;
use App\Models\ManagerDashboard\Assignments\Assignment;
use App\Models\ManagerDashboard\Assignments\AssignmentCommittee;
use App\Models\ManagerDashboard\Assignments\AssignmentTeam;
use App\Models\ManagerDashboard\Assignments\GeneralAssignment;
use App\Models\ManagerDashboard\Circulars\InternalCircular;
use App\Models\ManagerDashboard\Circulars\StudentGeneralCircular;
use App\Models\ManagerDashboard\Circulars\TeacherGeneralCircular;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassRoomVisitSession;
use App\Models\ManagerDashboard\Exams\NamazegPlans\DailyObservers\DailyObserves;
use App\Models\ManagerDashboard\Exams\NamazegPlans\MonitorDistributions\DistributionAssignment;
use App\Models\ManagerDashboard\Exams\NamazegPlans\NamozegAnswerSheetProgress\AnswerSheetProgress;
use App\Models\ManagerDashboard\Exams\NamazegPlans\TeacherDeclaration\TeacherCurriculumDeclaration;
use App\Models\ManagerDashboard\Exams\NamazegPlans\TeacherQuestionAssignment;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommittee;
use App\Models\ManagerDashboard\Exams\SupervisionCommittees\CorrectionAssignment;
use App\Models\ManagerDashboard\Exams\SupervisionCommittees\SupervisionAssignment;
use App\Models\ManagerDashboard\Namazeg\NamazegAbsenceDescionConfirm;
use App\Models\ManagerDashboard\Namazeg\NamazegAbsenceQuestioning;
use App\Models\ManagerDashboard\Namazeg\NamazegAcceptStudent;
use App\Models\ManagerDashboard\Namazeg\NamazegAssignProfessionalCommunities;
use App\Models\ManagerDashboard\Namazeg\NamazegAssignProfessionalCommunitiesEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegBooksDelivery;
use App\Models\ManagerDashboard\Namazeg\NamazegChemistLabInventoryRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegCircularAttendance;
use App\Models\ManagerDashboard\Namazeg\NamazegClassPlanActivity;
use App\Models\ManagerDashboard\Namazeg\NamazegDescionSumhoursLateleaving;
use App\Models\ManagerDashboard\Namazeg\NamazegEmployeeLeavingRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegEvacuationPlanReport;
use App\Models\ManagerDashboard\Namazeg\NamazegExcessDamageRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegExpermentExcutionRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegExpermentsPlan;
use App\Models\ManagerDashboard\Namazeg\NamazegFinalReportClassActivity;
use App\Models\ManagerDashboard\Namazeg\NamazegGuardianTransFrom;
use App\Models\ManagerDashboard\Namazeg\NamazegLabInventoryRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegMaintenanceForm;
use App\Models\ManagerDashboard\Namazeg\NamazegManagerPlane;
use App\Models\ManagerDashboard\Namazeg\NamazegMonitoringLateAbsenceTeacher;
use App\Models\ManagerDashboard\Namazeg\NamazegNotifyLateLeaving;
use App\Models\ManagerDashboard\Namazeg\NamazegQuestioning;
use App\Models\ManagerDashboard\Namazeg\NamazegRecieptRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegSchoolCommitment;
use App\Models\ManagerDashboard\Namazeg\NamazegStudentData;
use App\Models\ManagerDashboard\Namazeg\NamazegStudentFollow;
use App\Models\ManagerDashboard\Namazeg\NamazegTeacherExcuse;
use App\Models\ManagerDashboard\Namazeg\NamazegTeacherPerformanceFollow;
use App\Models\ManagerDashboard\Namazeg\NamazegTransformQuranStudent;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegDepartmentProceduresForm;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegDestructionProceed;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegFatherNotify;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegFatherNotiyStudentMove;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegGuidanceCommitteeMeeting;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegIncidentProceed;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegMaintenanceDestructionStudent;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegMinusStudentDescion;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegRedirectGuidance;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegSafetyCall;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegViolationAccedentProceed;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegViolationInvitaionLetter;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegViolationProceed;
use App\Models\ManagerDashboard\Namazeg\Violations\StudentViolationDegrees;
use App\Models\ManagerDashboard\OfficialSpeeches\Alert;
use App\Models\ManagerDashboard\OfficialSpeeches\Letter;
use App\Models\ManagerDashboard\Proceed;
use App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeAlert;
use App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeClassVisit;
use App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeWork;
use App\Models\ManagerDashboard\Reports\ManagerReports\AbsentLate;
use App\Models\ManagerDashboard\Reports\ManagerReports\AdministrativeWork;
use App\Models\ManagerDashboard\Reports\ManagerReports\CommitteesMeeting;
use App\Models\ManagerDashboard\Reports\ManagerReports\SchoolStatusStatistic;
use App\Models\ManagerDashboard\Reports\SchoolAdmisnstrativeReport\SchoolAdminstrativeAbsentLate;
use App\Models\ManagerDashboard\Reports\SchoolAdmisnstrativeReport\SchoolAdminstrativeWork;
use App\Models\ManagerDashboard\Reports\StudentAdmisnstrativeReport\StudentAdminstrativeAbsentLate;
use App\Models\ManagerDashboard\Reports\StudentAdmisnstrativeReport\StudentAdminstrativeWork;
use App\Models\ManagerDashboard\SupervisionSchedul;
use App\Models\ManagerDashboard\Tables\ClassRoomVisits\ClassroomVisit;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftSchedule;
use App\Models\ManagerDashboard\Tables\WaitingPeriodsSchedule\WaitingPeriodsSchedule;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Meeting;
use App\Models\ManagerDashboard\Violations\ViolationStudent;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use App\Models\TrashedRecord;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TrashedRecordController extends Controller
{
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */

    protected $models = [
        'absence_procedures' => [
            StudentAbsenceProcedure::class,
            StudentAbsenceProcedureSubItem::class,
        ],
        'lateness_procedures' => [
            StudentLatenessProcedure::class,
            StudentLatenessProcedureSubItem::class,
        ],
        'assignments' => [
            Assignment::class,
            AssignmentCommittee::class,
            AssignmentTeam::class,
            GeneralAssignment::class,
        ],
        'classroom_visits' => [
            ClassRoomVisitSession::class,
        ],
        'exams' => [
            DailyObserves::class,
            DistributionAssignment::class,
            AnswerSheetProgress::class,
            TeacherCurriculumDeclaration::class,
            TeacherQuestionAssignment::class,
            StudentCommittee::class,
            CorrectionAssignment::class,
            SupervisionAssignment::class,
        ],
        'namazeg' => [
            //violations
            NamazegDepartmentProceduresForm::class,
            NamazegDestructionProceed::class,
            NamazegFatherNotify::class,
            NamazegFatherNotiyStudentMove::class,
            NamazegGuidanceCommitteeMeeting::class,
            NamazegIncidentProceed::class,
            NamazegMaintenanceDestructionStudent::class,
            NamazegMinusStudentDescion::class,
            NamazegRedirectGuidance::class,
            NamazegSafetyCall::class,
            NamazegViolationAccedentProceed::class,
            NamazegViolationInvitaionLetter::class,
            NamazegViolationProceed::class,
            StudentViolationDegrees::class,
            // others
            NamazegAbsenceDescionConfirm::class,
            NamazegAbsenceQuestioning::class,
            NamazegAcceptStudent::class,
            NamazegAssignProfessionalCommunities::class,
            NamazegAssignProfessionalCommunitiesEmployee::class,
            NamazegBooksDelivery::class,
            NamazegChemistLabInventoryRecord::class,
            NamazegCircularAttendance::class,
            NamazegClassPlanActivity::class,
            NamazegDescionSumhoursLateleaving::class,
            NamazegEmployeeLeavingRecord::class,
            NamazegEvacuationPlanReport::class,
            NamazegExcessDamageRecord::class,
            NamazegExpermentExcutionRecord::class,
            NamazegExpermentsPlan::class,
            NamazegFinalReportClassActivity::class,
            NamazegGuardianTransFrom::class,
            NamazegLabInventoryRecord::class,
            NamazegMaintenanceForm::class,
            NamazegManagerPlane::class,
            NamazegMonitoringLateAbsenceTeacher::class,
            NamazegNotifyLateLeaving::class,
            NamazegQuestioning::class,
            NamazegRecieptRecord::class,
            NamazegSchoolCommitment::class,
            NamazegStudentData::class,
            NamazegStudentFollow::class,
            NamazegTeacherExcuse::class,
            NamazegTeacherPerformanceFollow::class,
            NamazegTransformQuranStudent::class,
        ],
        'official_speeches' => [
            Letter::class,
            Alert::class,
            InternalCircular::class,
            StudentGeneralCircular::class,
            TeacherGeneralCircular::class,
            Proceed::class,
        ],
        'reports' => [
            // EducationalAdmisnstrativeReport
            EducationalAdminstrativeAlert::class,
            EducationalAdminstrativeClassVisit::class,
            EducationalAdminstrativeWork::class,
            // ManagerReports
            AbsentLate::class,
            AdministrativeWork::class,
            CommitteesMeeting::class,
            SchoolStatusStatistic::class,
            // SchoolAdmisnstrativeReport
            SchoolAdminstrativeAbsentLate::class,
            SchoolAdminstrativeWork::class,
            // StudentAdmisnstrativeReport
            StudentAdminstrativeAbsentLate::class,
            StudentAdminstrativeWork::class,

        ],
        'tables' => [
            ClassroomVisit::class,
            ShiftSchedule::class,
            WaitingPeriodsSchedule::class,
            SupervisionSchedul::class,
        ],
        'teams_and_committees_meetings' => [
            Meeting::class,
        ],
        'Violations' => [
            ViolationStudent::class,
            ViolationStudentPunishment::class,
        ],
    ];

    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify','permission:trashed-records']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request)
    {
        // Validate incoming request
        $request->validate([
            'school_id' => 'required|exists:schools,id',
        ]);

        $models = Helper::flattenArray($this->models);

        /** empty old trashes then re add again */
        DB::statement('TRUNCATE TABLE trashed_records');

        foreach ($models as $key => $model) {
            $trashedRecords = $model::onlyTrashed()->get();

            foreach ($trashedRecords as $record) {
                if ((30 - Carbon::now()->diffInDays($record->deleted_at)) <= 0) {
                    $record = $model::withTrashed()->findOrFail($record->id);
                    $record->forceDelete();
                } else {
                    TrashedRecord::create([
                        'model' => class_basename($model),
                        'record_id' => $record->id,
                        'school_id' => $record->namozegVersion->school_id,
                        'namazeg_version_id' => $record->namozegVersion->id,
                        'deleted_at' => $record->deleted_at,
                    ]);
                }
            }
        }

        $perPage = $request->per_page ?? 15;

        if ($request->section) {
            // Retrieve all trashed records in specific section from the database
            $sections = [];
            $models = array_keys($this->models);
            if (!isset($this->models[$request->section])) return response()->json(['message' => trans('api.section not found')], 404);
            foreach ($this->models[$request->section] as $model) {
                $sections[] = class_basename($model);
            }

            $trashedRecords = TrashedRecord::where('school_id', $request->school_id)->whereIn('model', $sections)->paginate($perPage);
        } else {
            // Retrieve all trashed records from the database
            $trashedRecords = TrashedRecord::where('school_id', $request->school_id)->paginate($perPage);
        }

        // Get the precomputed class-to-section map
        $classToSectionMap = $this->getClassToSectionMap();

        // Add section name to each trashed record
        $trashedRecords->each(function ($item) use ($classToSectionMap) {
            // Lookup the section key from the map based on the item's model
            $sectionKey = $classToSectionMap[$item->model] ?? null;

            // Assign the section key to the item
            $item->section = trans('api.' . $sectionKey);

            return $item;
        });
        // Return them as a collection of resources
        TrashedRecordResource::collection($trashedRecords->getCollection());

        return response()->json(['trashedRecords' => $trashedRecords, 'message' => trans('api.list of all available records')], 200);
    }

    protected function getClassToSectionMap()
    {
        $classToSectionMap = [];

        // Loop through each section and map each class to the section key
        foreach ($this->models as $sectionKey => $classes) {
            foreach ($classes as $class) {
                $classToSectionMap[class_basename($class)] = $sectionKey;
            }
        }

        return $classToSectionMap;
    }

    public function getAllSections()
    {
        $sections = [];
        $models = array_keys($this->models);
        foreach ($models as $model) {
            $sections[$model] = trans('api.' . $model);
        }
        return response()->json([
            'sections' => $sections,
            'message' => trans('api.list of all available sections')
        ], 200);
    }

    public function restore(Request $request)
    {
        // Validate incoming request (optional but recommended)
        $request->validate([
            'model' => 'required|string',
            'record_id' => 'required|integer',
        ]);

        $models = Helper::flattenArray($this->models);

        $index = false;

        // Find the correct model in the array
        foreach ($models as $key => $class) {
            if (class_basename($class) === $request->model) {
                $index = $key;
                break;
            }
        }

        // Check if a valid model was found
        if ($index === false) {
            return response()->json(['message' => trans('api.model not found')], 404);
        }

        // Use the model to restore the soft-deleted record
        try {
            // Access the model class from the models array
            $modelClass = $models[$index];

            // Attempt to find and restore the soft-deleted record
            $record = $modelClass::withTrashed()->findOrFail($request->record_id);
            $record->restore(); // Restore the record here

            return response()->json(['message' => trans('api.record restored successfully')], 200);
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return response()->json(['message' => trans('api.record not found'), 'error' => $e->getMessage()], 404);
        } catch (\Exception $e) {
            return response()->json(['message' => trans('api.failed to restore record'), 'error' => $e->getMessage()], 500);
        }
    }

    public function delete(Request $request)
    {
        // Validate incoming request
        $request->validate([
            'records' => 'required|array',
            'records.*.model' => 'required|string',
            'records.*.id' => 'required|integer',
        ]);

        // Build an optimized model map once
        $modelMap = $this->buildModelMap();

        // Track results
        $results = [
            'success' => [],
            'failed' => []
        ];

        // Group records by model for efficient batch processing
        $recordsByModel = collect($request->records)
            ->groupBy('model')
            ->map(function ($items) {
                return $items->pluck('id')->toArray();
            });

        // Process each model batch
        foreach ($recordsByModel as $modelName => $ids) {
            // Check if model exists in our map
            if (!isset($modelMap[$modelName])) {
                // Add all records for this unknown model to failed results
                foreach ($ids as $id) {
                    $results['failed'][] = [
                        'model' => $modelName,
                        'id' => $id,
                        'reason' => 'model_not_found',
                        'message' => trans('api.model not found')
                    ];
                }
                continue;
            }

            $modelClass = $modelMap[$modelName];

            // Get all existing records in a single query
            $existingRecords = $modelClass::withTrashed()
                ->whereIn('id', $ids)
                ->get()
                ->keyBy('id');

            // Find missing records
            $missingIds = array_diff($ids, $existingRecords->pluck('id')->toArray());

            // Add missing records to failed results
            foreach ($missingIds as $id) {
                $results['failed'][] = [
                    'model' => $modelName,
                    'id' => $id,
                    'reason' => 'record_not_found',
                    'message' => trans('api.record not found')
                ];
            }

            // Process existing records
            foreach ($existingRecords as $record) {
                try {
                    $record->forceDelete();
                    $results['success'][] = [
                        'model' => $modelName,
                        'id' => $record->id
                    ];
                } catch (\Exception $e) {
                    $results['failed'][] = [
                        'model' => $modelName,
                        'id' => $record->id,
                        'reason' => 'delete_error',
                        'message' => $e->getMessage()
                    ];
                }
            }
        }

        return response()->json([
            'message' => count($results['success']) > 0
                ? trans('api.records deleted successfully')
                : trans('api.failed to delete records'),
            'deleted_count' => count($results['success']),
            'failed_count' => count($results['failed']),
            'results' => $results
        ], count($results['success']) > 0 ? 200 : 422);
    }

    /**
     * Build a map of model base names to their class references
     * 
     * @return array
     */
    private function buildModelMap(): array
    {
        $models = Helper::flattenArray($this->models);
        $modelMap = [];

        foreach ($models as $class) {
            $modelMap[class_basename($class)] = $class;
        }

        return $modelMap;
    }

    public function deleteAll()
    {
        $models = Helper::flattenArray($this->models);
        try {
            foreach ($models as $model) {
                $model::onlyTrashed()->forceDelete();
            }
            TrashedRecord::query()->delete();
            return response()->json(['message' => trans('api.records deleted successfully')], 200);
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return response()->json(['message' => trans('api.records not found'), 'error' => $e->getMessage()], 404);
        } catch (\Exception $e) {
            return response()->json(['message' => trans('api.failed to delete records'), 'error' => $e->getMessage()], 500);
        }
    }
}
