<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Tables\ShiftSchedules;

use App\Http\Controllers\Controller;
use App\Http\Resources\ManagerDashboard\Tables\ShiftSchedule\SemesterShiftResource;
use App\Http\Resources\ManagerDashboard\Tables\ShiftSchedule\ShiftScheduleResource;
use App\Jobs\SendSMSNotification;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\ManagerDashboard\NotificationSettings\NotificationSchoolSetting;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftSchedule;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftScheduleDay;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftTeacher;
use App\Models\Namazeg;
use App\Traits\LogsActivity;
use App\Traits\NamazegTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use JWTAuth;
use Illuminate\Support\Facades\Validator;


class ShiftScheduleController extends Controller
{
    use LogsActivity, NamazegTrait;

    public function __construct()
    {
        //$this->middleware(['auth:api','permission:shift-schedules']);
    }

    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School:: where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        $semesterShiftSchedules = SemesterShiftResource::collection(SchoolSemester::where('status','1')->get());
        return response()->json(['semesterShiftSchedules'=>$semesterShiftSchedules,'message' => trans('api.list of all available records')]);
    }

    /**
     * Display the specified resource.
     */
    public function getById(Request $request)
    {
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School:: where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        $shiftSchedule = ShiftSchedule::findOrFail($request->shift_schedule_id);
        $shiftSchedule = new ShiftScheduleResource($shiftSchedule);

        $ShiftScheduleTeachers = ShiftTeacher::where('school_id',$school->id)->where('shift_schedule_id',$shiftSchedule->id)->get();

        if(count($ShiftScheduleTeachers) >0){
            return response()->json(['shiftSchedule' => $shiftSchedule,'message' => trans('api.shift schedule')]);
        }
        return response()->json(['shiftSchedule' => $shiftSchedule,'message' => trans('api.shift schedule')]);
    }

    /**
     * function store shift schduke informations
     */
    public function store(Request $request)
    {
        $token = $request->bearerToken();
        if ($token) {
            $user = JWTAuth::toUser($token);
        }

        // Validate that the school exists for this user
        $school = School::where('user_id', $user->id)
            ->where('id', $request->school_id)
            ->firstOrFail();
        // Validate input data
        $validator = Validator::make($request->all(), [
            'shift_schedule_id' => 'required|exists:shift_schedules,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }
        $shiftSchedule = ShiftSchedule::findOrFail($request->shift_schedule_id);

        /** create or update  namozg version for this table*/
        $namozeg = Namazeg::where('form_number', 47)->first();
        $namazeg_version_id = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $request->school_id
        )->id;

        $shiftSchedule->updateOrCreate(
            ['id' => $shiftSchedule->id],
            ['namazeg_version_id' => $namazeg_version_id]
        );
        $shiftSchedule->save();

        $checkIfCreated =  ShiftTeacher::where('school_id',$school->id)->where('shift_schedule_id',$shiftSchedule->id)->exists();
        if(!$checkIfCreated){
            /** create new table */
            $shiftScheduleDays= ShiftScheduleDay::where('shift_schedule_id',$request->shift_schedule_id)->where('semester_id',$shiftSchedule->semester_id)->get();
            foreach($shiftScheduleDays as $shiftScheduleDay){
                $shiftTeachers = ShiftTeacher::create([
                    'shift_schedule_id' => $shiftSchedule->id,
                    'school_id' => $school->id,
                    'shift_schedule_day_id' => $shiftScheduleDay->id,
                    'school_employee_id' => NULL,
                ]);

            }

            $shiftTeachers = ShiftTeacher::where('shift_schedule_id',$request->shift_schedule_id)->get();
            $teacherIds  = $request->teacher_id;
            foreach ($shiftTeachers as $key => $shiftTeacher) {
                if(isset($teacherIds[$key])){
                    $namazeg_version_ids =[];
                    $namozeg = Namazeg::where('form_number', 48)->first();
                    $namazeg_version_id = $this->storeNamazegVersion(
                        $namozeg->id,
                        $namozeg->internal_extenral,
                        $request->school_id
                    )->id;
                }
                // رسالة للمعلمين فى المناوبة فى نفس اليوم الفجر
                $notification_setting_shift_schedual = NotificationSchoolSetting::where('school_id', $request->school_id)->where('notification_setting_id', 6)->first();
                if ($notification_setting_shift_schedual->messages) {
                    $message_text = "لديك مناوبة اليوم , نرجو الالتزام بالحضور وفق الجدول.";
                    $schedual_date = $shiftTeacher->day->semesterWeekDay->date;
                    $sendAt = Carbon::createFromFormat('d/m/Y', $schedual_date)->setTime(3, 0, 0);
                    SendSMSNotification::dispatch($shiftTeacher->teacher->phone, $message_text, $user->manager_id)->delay($sendAt);
                }
                $shiftTeacher->update([
                    'school_employee_id' => (isset($teacherIds[$key]))?  implode(",", $teacherIds[$key]):NULL,
                    'namazeg_version_id'=>(isset($teacherIds[$key]))? $namazeg_version_id:NULL,
                ]);
            }

            return response()->json(['message' => trans('api.shift schedule created successfully')]);
        }elseif(count($request->teacher_id) == 0){
            return response()->json(['message' => trans('api.shift schedule already exists')]);
        }
        $shiftTeachers = ShiftTeacher::where('shift_schedule_id',$request->shift_schedule_id)->get();

        $teacherIds  = $request->teacher_id;

        foreach ($shiftTeachers as $key => $shiftTeacher) {
            if(isset($teacherIds[$key])){
                $namazeg_version_ids =[];
                $namozeg = Namazeg::where('form_number', 48)->first();
                $namazeg_version_id = $this->storeNamazegVersion(
                    $namozeg->id,
                    $namozeg->internal_extenral,
                    $request->school_id
                )->id;
            }
            // رسالة للمعلمين فى المناوبة فى نفس اليوم الفجر
            $notification_setting_shift_schedual = NotificationSchoolSetting::where('school_id', $request->school_id)->where('notification_setting_id', 6)->first();
            if ($notification_setting_shift_schedual->messages) {
                $message_text = "لديك مناوبة اليوم , نرجو الالتزام بالحضور وفق الجدول.";
                $schedual_date = $shiftTeacher->day->semesterWeekDay->date;
                $sendAt = Carbon::createFromFormat('d/m/Y', $schedual_date)->setTime(3, 0, 0);
                SendSMSNotification::dispatch($shiftTeacher->teacher?->phone, $message_text, $user->manager_id)->delay($sendAt);
            }
            $shiftTeacher->update([
                'school_employee_id' => (isset($teacherIds[$key]))?  implode(",", $teacherIds[$key]):NULL,
                'namazeg_version_id'=>(isset($teacherIds[$key]))? $namazeg_version_id:NULL,
            ]);
        }
        return response()->json(['message' => trans('api.shift schedule updated successfully')]);
    }
}
