<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Settings\Subscriptions\System;

use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Settings\Subscription;
use App\Models\ManagerDashboard\Settings\BusinessAccountData;
use App\Http\Requests\ManagerDashboard\Setting\StoreCompanyPurchasesRequest;
use App\Models\AdminDashboard\Coupons\Coupon;
use App\Models\AdminDashboard\Products\Product;

class SystemSubscriptionController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public static function renewSubscription(Request $request, School $school)
    {

        $data = $request->validate([
            'coupon_id' => 'nullable|exists:coupons,id',
        ]);

        // $subscription = Subscription::where('user_id', auth()->user()->id)
        //     ->where('service_type', 'system')
        //     ->firstOrFail();


        // $product = Product::where('id', $subscription->product_id)->firstOrfail();
        $product = Product::where('id', 1)->firstOrfail();


        $subscription_fee = $product->price;


        $tax_fees = $subscription_fee * 0.15;
        $tax_fees = round($tax_fees);
        $tax_fees = (int) $tax_fees;

        if (isset($data['coupon_id'])) {
            $coupon = Coupon::where('id', $data['coupon_id'])->firstOrFail();

            // Calculate the discount amount
            $discount_amount = ($coupon->discount_type === 'fixed')
                ? min($coupon->discount_value, $subscription_fee) // Ensure discount doesn't exceed fee
                : $subscription_fee  * $coupon->discount_value / 100;
        }

        $discount_amount =  $discount_amount ?? 0;

        $total_price = max(0, $subscription_fee - $discount_amount);


        // $subscription->update([
        //     'product_id' => $product->id,
        //     'status' => 'not_subscribed',
        //     'subscription_fee' => $subscription_fee,
        //     'tax_fees' => $tax_fees,
        //     'coupon_id' => $data['coupon_id'] ?? null,
        //     'coupon_discount' => $discount_amount,
        //     'paid_status' => 'Unpaid',
        //     'total_price' => $total_price,


        // ]);
        $subscription =   Subscription::create([
            'user_id'=>Auth()->user()->id,
            'product_id' => $product->id,
            'status' => 'not_subscribed',
            'service_type'=> 'system',
            'subscription_fee' => $subscription_fee,
            'tax_fees' => $tax_fees,
            'coupon_id' => $data['coupon_id'] ?? null,
            'coupon_discount' => $discount_amount,
            'paid_status' => 'Unpaid',
            'total_price' => $total_price,


        ]);

        return response()->json([
            'message' => 'تمت عملية بدء الدفع بنجاح',
            'subscription_id' => $subscription->id,
            'Subtotal' => $subscription_fee,
            'tax_fees' => $tax_fees,
            'discount_amount' => $discount_amount,
            'total_price' => $total_price,
            'subscription_type' => $product->name,
        ]);
    }

    public function companyPurchases(StoreCompanyPurchasesRequest $request, School $school)
    {
        $data = $request->validated();

        BusinessAccountData::updateOrcreate(

            ['user_id'=>auth()->user()->id],
            [
                'user_id' =>  auth()->user()->id,
                'company_name' => $data['company_name'],
                'sector' => $data['sector'],
                'tax_registration_number' => $data['tax_registration_number'],
                'commercial_registration_number' => $data['commercial_registration_number'],
            ]
        );
        return response()->json(['message' => 'تم تحويل الحساب الي حساب اعمال']);
    }

    public function deleteCompanyPurchases()
    {
        $BusinessAccount =  BusinessAccountData::where('user_id', auth()->user()->id)->firstOrFail();
        $BusinessAccount->delete();
        return response()->json(['message' => 'تم حذف بيانات حساب الاعمال بنجاح']);
    }

    public function SchoolData(School $school)
    {

        $systemSubscription =  Product::select('id', 'name', 'price')->where('type', 'subscription')->firstOrFail();
        $data = [
            'id' => $school->id,
            'name' => $school->name,
            'educationalOffice' => $school->educationalOffice->name,
            'phone' => auth()->user()->phone,
            'email' => auth()->user()->email,
            'system_subscription' =>  $systemSubscription,
            'bussines_account_data' => auth()->user()->bussinessData ? [
                'company_name' => auth()->user()->bussinessData?->company_name,
                'sector' => auth()->user()->bussinessData?->sector,
                'tax_registration_number' => auth()->user()->bussinessData?->tax_registration_number,
                'commercial_registration_number' => auth()->user()->bussinessData?->commercial_registration_number,
            ] : null,
        ];
        return response()->json(['data' => $data]);
    }
    /**
     * Display the specified resource.
     */
    public function show()
    {
        // dd('dsa',auth()->user()->id);
        $systemSubscription = Subscription::select('start_date', 'end_date', 'status')
            ->where('user_id', auth()->user()->id)
            ->where('service_type', 'system')->firstOrFail();

        $subscriptions = Subscription::where('user_id', auth()->user()->id)
            ->where('paid_type', '!=', Null)
            ->get();

        $currentDate = Carbon::now();  // Get the current date and time
        $endDate = Carbon::createFromFormat('d/m/Y', $systemSubscription->end_date); // Parse the subscription's end date

        // Calculate the difference in days
        $daysRemaining = $currentDate->diffInDays($endDate);

        // translate subscription status to arabic
        if ($systemSubscription->status == 'Experimental') {
            $systemSubscription->status = 'تجريبي';
        } elseif ($systemSubscription->status == 'subscribed') {
            $systemSubscription->status = 'مشترك';
        } elseif ($systemSubscription->status == 'not_subscribed') {
            $systemSubscription->status = 'غير مشترك';
        }
        $response = [
            'systemSubscription' => $systemSubscription,
            'days_remaining' => $daysRemaining,
            'invoices' => $subscriptions->map(function ($subscription) {
                return [
                    'id' => $subscription->id,
                    'order_number' => $subscription->order_number,
                    'service_name' => $subscription->service_type,
                    'total_price' => $subscription->total_price,
                    'paid_status' => $subscription->paid_status,
                    'paid_date' => $subscription->transactionData?->transfer_date,

                ];
            }),

        ];
        return response()->json(['data' => $response]);
    }

    public function cancelSubscription(Request $request)
    {

        $data = $request->validate(['cancellation_reason'=> 'required','string']);

        $user_id = auth()->user()->id;

        $subscription = Subscription::where('user_id',$user_id)->where('service_type','system')->firstOrFail();

        $subscription->update([
            'cancellation_request_status' => 'requested',
            'cancellation_reason' => $data['cancellation_reason']
        ]);

       return response()->json(['message' => 'سيتم التواصل معك خلال 24 ساعة ']);
    }
}
