<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Settings;

use App\Helpers\Helper;
use App\Http\Controllers\Api\ManagerDashboard\Exams\NamazegPlans\TeacherQuestionAssignment;
use App\Http\Controllers\Controller;
use App\Http\Resources\User\UserResource;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolFacilitie;
use App\Models\AdminDashboard\School\SchoolReference;
use App\Models\OtpVerification;
use App\Models\User;
use App\Traits\SmsTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use JWTAuth;

class GeneralSettingController extends Controller
{
    use SmsTrait;

    public function __construct()
    {
        //$this->middleware(['auth:api','permission:general-settings']);
    }

    public function sendOtpBeforeUpdate(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        $validator = Validator::make($request->all(), [
            'email' => 'required|email|unique:users,email,'.$user->id,
            'phone' => 'required|unique:users,phone,'.$user->id,
        ]);

        if($validator->fails()){
            $errors = $validator->errors();
            foreach ($errors->all() as $message) {
                $error[] =  trans("api.$message");
            }
            return response()->json(['message'=>trans('api.error entering data'),'errors'=>$validator->errors()],422);
        }

        /** send otp */
        $otp = mt_rand(1000, 9999);

        OtpVerification::updateOrCreate(
            ['phone' => $request->phone],
            [
                'otp' => $otp,
                'expires_at' => Carbon::now()->addMinutes(5)
            ]
        );

        $this->sendOTP($request->phone,$otp);

        return response()->json(['otp'=>$otp,'phone'=>$request->phone,'message'=>trans('api.verify mobile number before update , not otp will expire after 5 mins')]);
    }

    public function verifyOtpAndUpdateInfo(Request $request)
    {
        $otpRecord = OtpVerification::where('phone', $request->phone)->first();
        if (!$otpRecord) {
            return response()->json(['message' => trans('api.Phone number not found or OTP expired.')], 400);
        }
        if ($otpRecord->otp != $request->otp) {
            return response()->json(['message' => trans('api.Invalid OTP.')], 400);
        }
        if (Carbon::now()->greaterThan($otpRecord->expires_at)) {
            return response()->json(['message' => trans('api.OTP has expired.')], 400);
        }
        $otpRecord->delete();

        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $user->email=$request->email;
        $user->phone=$request->phone;
        $user->save();
        return response()->json(['message' => 'OTP verified successfully. and user record updated successfully.']);
    }

    public function changeSchoolType(Request $request)
    {
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $userSchools = $user->schools;

        if(count($userSchools) == 2 && $request->type == 'shared'){
            return response()->json(['message' => trans('api.now you have 2 schools you can not update to shared')], 400);
        }

        if(count($userSchools) < 2 && $request->type == 'shared'){
            /**school 1 */
            $school1= School::find($request->school_id);
            $adminstrative1 = SchoolEmployee::where('school_id',$school1->id)->first();

            /**school 2 */
            $school2= School::create(['user_id'=>$user->id,'current_school_year'=>Helper::getSchoolYear(),'reg_step1'=>'completed']);
            $school2Facilities= SchoolFacilitie::create(['school_id'=>$school2->id]);
            $school2Reference= SchoolReference::create(['school_id'=>$school2->id]);

            if($adminstrative1){
                $adminstrative2 = new SchoolEmployee();
                $adminstrative2->fill($adminstrative1->toArray());
                $adminstrative2->id = null;
                $adminstrative2->school_id = $school2->id;
                $adminstrative2->save();
            }

            return response()->json(['school_id'=>$school2->id,'message' => trans('api.now new school created')]);
        }

        if(count($userSchools) == 2 && $request->type == 'not_shared' && $request->school_id !=NULL){
            $school = School::find($request->school_id );
            if(!$school){
                return response()->json(['message' => trans('api.no school found with this id')], 400);
            }

            $school->forceDelete();
            return response()->json(['message' => trans('api.school has been deleted')]);
        }
    }

}
