<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Settings;

use App\Http\Controllers\Controller;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolEmployeeAttendance;
use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\AbsenseAndLateness\PeriodStudentAttendance;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAbsenceProcedure;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAttendance;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentLateness;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentLatenessProcedure;
use App\Models\ManagerDashboard\Assignments\Assignment;
use App\Models\ManagerDashboard\Assignments\AssignmentCommittee;
use App\Models\ManagerDashboard\Assignments\AssignmentTeam;
use App\Models\ManagerDashboard\Assignments\GeneralAssignment;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassRoomVisitSession;
use App\Models\ManagerDashboard\Exams\NamazegPlans\DailyObservers\DailyObserves;
use App\Models\ManagerDashboard\Exams\NamazegPlans\MonitorDistributions\DistributionAssignment;
use App\Models\ManagerDashboard\Exams\NamazegPlans\NamozegAnswerSheetProgress\AnswerSheetProgress;
use App\Models\ManagerDashboard\Exams\NamazegPlans\TeacherDeclaration\TeacherCurriculumDeclaration;
use App\Models\ManagerDashboard\Exams\NamazegPlans\TeacherQuestionAssignment;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommittee;
use App\Models\ManagerDashboard\Exams\SupervisionCommittees\CorrectionAssignment;
use App\Models\ManagerDashboard\Messages\Message;
use App\Models\ManagerDashboard\Namazeg\NamazegAbsenceDescionConfirm;
use App\Models\ManagerDashboard\Namazeg\NamazegAbsenceQuestioning;
use App\Models\ManagerDashboard\Namazeg\NamazegAcceptStudent;
use App\Models\ManagerDashboard\Namazeg\NamazegAssignProfessionalCommunities;
use App\Models\ManagerDashboard\Namazeg\NamazegBooksDelivery;
use App\Models\ManagerDashboard\Namazeg\NamazegChemistLabInventoryRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegCircularAttendance;
use App\Models\ManagerDashboard\Namazeg\NamazegClassPlanActivity;
use App\Models\ManagerDashboard\Namazeg\NamazegDescionSumhoursLateleaving;
use App\Models\ManagerDashboard\Namazeg\NamazegEmployeeLeavingRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegEvacuationPlanImages;
use App\Models\ManagerDashboard\Namazeg\NamazegEvacuationPlanReport;
use App\Models\ManagerDashboard\Namazeg\NamazegExcessDamageRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegExpermentExcutionRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegExpermentsPlan;
use App\Models\ManagerDashboard\Namazeg\NamazegFinalReportClassActivity;
use App\Models\ManagerDashboard\Namazeg\NamazegGuardianTransFrom;
use App\Models\ManagerDashboard\Namazeg\NamazegLabInventoryRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegMaintenanceForm;
use App\Models\ManagerDashboard\Namazeg\NamazegManagerPlane;
use App\Models\ManagerDashboard\Namazeg\NamazegMonitoringLateAbsenceTeacher;
use App\Models\ManagerDashboard\Namazeg\NamazegNotifyLateLeaving;
use App\Models\ManagerDashboard\Namazeg\NamazegQuestioning;
use App\Models\ManagerDashboard\Namazeg\NamazegRecieptRecord;
use App\Models\ManagerDashboard\Namazeg\NamazegSchoolCommitment;
use App\Models\ManagerDashboard\Namazeg\NamazegStudentData;
use App\Models\ManagerDashboard\Namazeg\NamazegStudentFollow;
use App\Models\ManagerDashboard\Namazeg\NamazegTeacherExcuse;
use App\Models\ManagerDashboard\Namazeg\NamazegTeacherPerformanceFollow;
use App\Models\ManagerDashboard\Namazeg\NamazegTransformQuranStudent;
use App\Models\ManagerDashboard\Namazeg\Violations\StudentViolationDegrees;
use App\Models\ManagerDashboard\OfficialSpeeches\Alert;
use App\Models\ManagerDashboard\OfficialSpeeches\Letter;
use App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeAlert;
use App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeClassVisit;
use App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeWork;
use App\Models\ManagerDashboard\Reports\ManagerReports\AbsentLate;
use App\Models\ManagerDashboard\Reports\ManagerReports\AdministrativeWork;
use App\Models\ManagerDashboard\Reports\ManagerReports\CommitteesMeeting;
use App\Models\ManagerDashboard\Reports\ManagerReports\SchoolStatusStatistic;
use App\Models\ManagerDashboard\Reports\SchoolAdmisnstrativeReport\SchoolAdminstrativeAbsentLate;
use App\Models\ManagerDashboard\Reports\SchoolAdmisnstrativeReport\SchoolAdminstrativeWork;
use App\Models\ManagerDashboard\Reports\StudentAdmisnstrativeReport\StudentAdminstrativeAbsentLate;
use App\Models\ManagerDashboard\Reports\StudentAdmisnstrativeReport\StudentAdminstrativeWork;
use App\Models\ManagerDashboard\SupervisionSchedul;
use App\Models\ManagerDashboard\Supervisor;
use App\Models\ManagerDashboard\Tables\ClassRoomVisits\ClassroomVisit;
use App\Models\ManagerDashboard\Tables\Exams\TableExam;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftTeacher;
use App\Models\ManagerDashboard\Tables\WaitingPeriodsSchedule\WaitingPeriodsSchedule;
use App\Models\ManagerDashboard\TeacherSchedule;
use App\Models\ManagerDashboard\TeacherScheduleData;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Team;
use App\Models\ManagerDashboard\Violations\ViolationStudent;
use Illuminate\Http\Request;

class FactoryResetController extends Controller
{
    /* to uses the class methods
        -you should be authenticated
        -you should be authorized and have this permission
    */

    private $models = [
        'school_students' => [
            Student::class,
        ],
        'school_teachers' => [
            SchoolEmployee::class,
        ],
        'school_administratives' => [
            SchoolEmployee::class,
        ],
        'teams_and_committees' => [
            Team::class,
            Committee::class,
        ],
        'assignments' => [
            Assignment::class,
            AssignmentCommittee::class,
            AssignmentTeam::class,
            GeneralAssignment::class,
        ],
        'tables' => [
            TeacherScheduleData::class,
            ClassroomVisit::class,
            TableExam::class,
            ShiftTeacher::class,
            WaitingPeriodsSchedule::class,
            Supervisor::class,
        ],
        'class_visits' => [
            ClassRoomVisitSession::class,
        ],
        'exams' => [
            DailyObserves::class,
            DistributionAssignment::class,
            AnswerSheetProgress::class,
            TeacherCurriculumDeclaration::class,
            TeacherQuestionAssignment::class,
            StudentCommittee::class,
            CorrectionAssignment::class,
        ],
        'student_violations_and_attendance' => [
            //attendance
            StudentAttendance::class,
            StudentLateness::class,
            PeriodStudentAttendance::class,
            StudentAbsenceProcedure::class,
            StudentLatenessProcedure::class,
            //violations
            ViolationStudent::class,
        ],
        'official_speeches' => [
            Alert::class,
            Letter::class,
        ],
        'messages' => [
            Message::class,
        ],
        'reports' => [
            EducationalAdminstrativeAlert::class,
            EducationalAdminstrativeClassVisit::class,
            EducationalAdminstrativeWork::class,

            AbsentLate::class,
            AdministrativeWork::class,
            CommitteesMeeting::class,
            SchoolStatusStatistic::class,

            SchoolAdminstrativeAbsentLate::class,
            SchoolAdminstrativeWork::class,

            StudentAdminstrativeAbsentLate::class,
            StudentAdminstrativeWork::class,
        ],
        'namazeg' => [
            //violations
            ViolationStudent::class,
            //others
            NamazegAbsenceDescionConfirm::class,
            NamazegAbsenceQuestioning::class,
            NamazegAcceptStudent::class,
            NamazegAssignProfessionalCommunities::class,
            NamazegBooksDelivery::class,
            NamazegChemistLabInventoryRecord::class,
            NamazegCircularAttendance::class,
            NamazegClassPlanActivity::class,
            NamazegDescionSumhoursLateleaving::class,
            NamazegEmployeeLeavingRecord::class,
            NamazegEvacuationPlanImages::class,
            NamazegEvacuationPlanReport::class,
            NamazegExcessDamageRecord::class,
            NamazegExpermentExcutionRecord::class,
            NamazegExpermentsPlan::class,
            NamazegFinalReportClassActivity::class,
            NamazegGuardianTransFrom::class,
            NamazegLabInventoryRecord::class,
            NamazegMaintenanceForm::class,
            NamazegManagerPlane::class,
            NamazegMonitoringLateAbsenceTeacher::class,
            NamazegNotifyLateLeaving::class,
            NamazegQuestioning::class,
            NamazegRecieptRecord::class,
            NamazegSchoolCommitment::class,
            NamazegStudentData::class,
            NamazegStudentFollow::class,
            NamazegTeacherExcuse::class,
            NamazegTeacherPerformanceFollow::class,
            NamazegTransformQuranStudent::class,
        ],
    ];

    public function __construct()
    {
        //$this->middleware(['auth:api','permission:manager-factory-reset-settings']);
    }

    public function schoolEmployeesAttendanceReset(Request $request)
    {
        $request->validate([
            'school_id' => 'required|exists:schools,id',
        ]);

        SchoolEmployeeAttendance::where('school_id', $request->school_id)->forceDelete();

        return response()->json(['message' => trans('api.school employee attendance have been reset successfully')]);
    }

    public function SystemReset(Request $request)
    {
        $request->validate([
            'school_id' => 'required|exists:schools,id',
            'sections' => 'required|array',
        ]);

        foreach ($request->sections as $key) {
            if ($this->models[$key]) {
                switch ($key) {
                    case 'school_students':
                        Student::where('school_id', $request->school_id)->withTrashed()->forceDelete();
                        break;
                    case 'school_teachers':
                        SchoolEmployee::where('school_id', $request->school_id)->where('type', 'teacher')->withTrashed()->forceDelete();
                        break;
                    case 'school_administratives':
                        SchoolEmployee::where('school_id', $request->school_id)->where('type', 'adminstrative')->withTrashed()->where('current_work_id', '!=', 1)->forceDelete();
                        break;
                    case 'assignments':
                        Assignment::where('school_id', $request->school_id)->where('current_work_id', '!=', 1)->withTrashed()->forceDelete();
                        AssignmentCommittee::where('school_id', $request->school_id)->withTrashed()->forceDelete();
                        AssignmentTeam::where('school_id', $request->school_id)->withTrashed()->forceDelete();
                        GeneralAssignment::where('school_id', $request->school_id)->withTrashed()->forceDelete();
                        break;
                    case 'tables':
                        $teacherScheduleIds = TeacherSchedule::where('school_id', $request->school_id)->pluck('id')->toArray();
                        TeacherScheduleData::whereIn('teacher_schedule_id', $teacherScheduleIds)->forceDelete();

                        ClassroomVisit::where('school_id', $request->school_id)->forceDelete();
                        TableExam::where('school_id', $request->school_id)->forceDelete();
                        ShiftTeacher::where('school_id', $request->school_id)->withTrashed()->forceDelete();
                        WaitingPeriodsSchedule::where('school_id', $request->school_id)->forceDelete();

                        $supervisionSchedulIds = SupervisionSchedul::where('school_id', $request->school_id)->withTrashed()->pluck('id')->toArray();
                        Supervisor::whereIn('supervision_schedule_id', $supervisionSchedulIds)->forceDelete();
                        break;
                    case 'namazeg':
                        StudentViolationDegrees::join('namazeg_versions', 'namazeg_versions.id', '=', 'student_violation_degrees.namazeg_version_id')->where('school_id', $request->school_id)->withTrashed()->forceDelete();
                        foreach ($this->models[$key] as $model) {
                            if (in_array(SoftDeletes::class, class_uses($model))) {
                                $model::where('school_id', $request->school_id)->withTrashed()->forceDelete();
                            } else {
                                $model::where('school_id', $request->school_id)->forceDelete();
                            }
                        }
                        break;
                    default:
                        foreach ($this->models[$key] as $model) {
                            if (in_array(SoftDeletes::class, class_uses($model))) {
                                $model::where('school_id', $request->school_id)->withTrashed()->forceDelete();
                            } else {
                                $model::where('school_id', $request->school_id)->forceDelete();
                            }
                        }
                        break;
                }
            }
        }

        return response()->json(['message' => trans('api.selected sections have been reset successfully')]);
    }
}
