<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Settings;

use App\Helpers\Helper;
use App\Http\Controllers\Api\ManagerDashboard\Exams\NamazegPlans\TeacherQuestionAssignment;
use App\Http\Controllers\Controller;
use App\Http\Resources\School\SchoolEmployeeResource;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\User;
use App\Traits\SmsTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Spatie\Permission\Models\Role;
use JWTAuth;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Cache;
use Mail;

class AdminstrativeSettingController extends Controller
{

    use SmsTrait;
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:adminstrative-settings']);
    }

    public function changeAccountStatus(Request $request)
    {
        // $token = $request->bearerToken();
        // if ($token) {
        //     $user = JWTAuth::toUser($token);
        // }
        // $school = School::where('user_id', $user->id)->where('id', $request->school_id)->firstOrFail();

        $school = School::findOrFail($request->school_id);

        $user = User::find($request->user_id);
        if ($user) {
            /** update user account status */
            $user->status = $request->status;
            $user->save();
            return response()->json(['account_current_status' => trans("api.$user->status"), 'message' => trans('api.account status changed')]);
        } else {
            return response()->json(['message' => trans('api.no data found to this id')], 404);
        }
    }

    public function sendSystemAccountCredentials(Request $request)
    {
        // $token = $request->bearerToken();
        // if ($token) {
        //     $user = JWTAuth::toUser($token);
        // }
        // $school = School::where('user_id', $user->id)->where('id', $request->school_id)->firstOrFail();
        $school = School::findOrFail($request->school_id);

        $user = User::find($request->user_id);
        if (!$user) {
            return response()->json(['message' => trans('api.User not found.')], 404);
        }

        //send sms with system account credentials//
        $this->sendSystemAccount($user->phone, $user->id);

        return response()->json(['message' => trans('api.account sent successfully')]);
    }

    public function printSystemAccountCredentials(Request $request)
    {
        // $token = $request->bearerToken();
        // if ($token) {
        //     $user = JWTAuth::toUser($token);
        // }
        //$school = School::where('user_id', $user->id)->where('id', $request->school_id)->firstOrFail();
        $school = School::findOrFail($request->school_id);

        $user = User::find($request->user_id);
        if (!$user) {
            return response()->json(['message' => trans('api.User not found')], 404);
        }

        // Retrieve user information
        $tempPassword = Str::random(8);
        $user->password_reseted = 'no';
        $user->password = bcrypt($tempPassword);
        $user->save();

        $credentials = [
            'school_name' => $school->name,
            'date'=>date('d/m/Y'),
            'username' => $user->name ?? 'N/A',
            'current_work' => $user->employee?->currentWork?->name ?? 'N/A',
            'email' => $user->email,
            'temporary_password' => $tempPassword
        ];

        return response()->json([
            'data' => $credentials,
            'message' => trans('api.account data to print')
        ]);
    }


    public function addNewSystemAccount(Request $request)
    {
        // $token = $request->bearerToken();
        // if ($token) {
        //     $user = JWTAuth::toUser($token);
        // }
        // $school = School::where('user_id', $user->id)->where('id', $request->school_id)->firstOrFail();
        $school = School::findOrFail($request->school_id);

        $adminstrative = SchoolEmployee::where('school_id',$school->id)->where('id',$request->school_employee_id)->firstOrFail();
        if ($adminstrative->have_account == 'yes') {
            return response()->json(['message' => trans('api.account already exists')], 400);
        }
        //$tempPassword = $request->temp_password;
        $tempPassword = Str::random(8);
        $this->createUserAccounts($adminstrative->id, $adminstrative->name, $adminstrative->email, $adminstrative->phone, $tempPassword);

        $newAccount = User::find($adminstrative->user_id);
        $newAccount->user_type = ($adminstrative->type = 'teacher')? 'school_manager,teacher':'school_manager';
        $newAccount->save();

        $credentials = [
            'username' => $newAccount->name ?? 'N/A',
            'current_work' => $newAccount->employee?->currentWork?->name ?? 'N/A',
            'email' => $newAccount->email,
            'temporary_password' => $tempPassword
        ];

        return response()->json([
            'data' => $credentials,
            'message' => trans('api.account sent successfully')
        ]);
    }

    public function createUserAccounts($empId, $name, $email, $phone, $temp_password)
    {
        $user = new User();
        $user->name = $name;
        $user->email = $email;
        $user->phone = $phone;
        $user->password = Hash::make($temp_password);
        $user->remember_token = 'no';
        $user->status = 'active';
        $user->user_type = 'teacher';
        $user->password_reseted = 'no';
        $user->verification_code = mt_rand(100000, 999999);
        $user->save();

        /** add user Id to school employee */
        $schoolEmployee = SchoolEmployee::find($empId);
        $schoolEmployee->user_id = $user->id;
        $schoolEmployee->have_account = 'yes';
        $schoolEmployee->save();
    }

    public function getPermissions(Request $request){
        $permissions = Permission::where('parent_id',0)->where('type', 'school_manager')->get();
        $user = User::findOrFail($request->user_id);
        $userPermissions = $user->getAllPermissions();

        $intersectedPermissions = $permissions->map(function ($permission) use ($userPermissions) {
            $isIntersected = $userPermissions->contains('id', $permission->id);
            $subPermissions = $this->getSubPermissions($permission->id, $userPermissions);
            if ($isIntersected || !empty($subPermissions)) {
                return [
                    'id' => $permission->id,
                    'name' => $permission->name,
                    'name_ar' => $permission->name_ar,
                    'is_intersected' => $isIntersected,
                    'sub_permissions' => $subPermissions,
                ];
            }else{
                return [
                    'id' => $permission->id,
                    'name' => $permission->name,
                    'name_ar' => $permission->name_ar,
                    'is_intersected' => $isIntersected,
                    'sub_permissions' => [],
                ];
            }

            return null;
        })->filter()->values();
        return response()->json([
            'role_permissions' => $intersectedPermissions,
            'message' => trans('api.list_of_all_available_records'),
        ]);
    }

    private function getSubPermissions($parent_id, $userPermissions){
        // Clear the entire cache
        Cache::flush();

        $permissions = Permission::where('parent_id', $parent_id)->get();
        if ($permissions->isEmpty()) {
            return [];
        }
        return $permissions->map(function ($permission) use ($userPermissions) {
            $isIntersected = $userPermissions->contains('id', $permission->id);
            $subPermissions = $this->getSubPermissions($permission->id, $userPermissions);
            return [
                'id' => $permission->id,
                'name' => $permission->name,
                'name_ar' => $permission->name_ar,
                'is_intersected' => $isIntersected,
                'sub_permissions' => $subPermissions,
            ];
        })->all();
    }


    public function updatePermissions(Request $request){
        // Clear the entire cache
        Cache::flush();

        $user = User::findOrFail($request->user_id);

        /** check if user is school manager*/
        $schoolEmployee = SchoolEmployee::where('user_id',$user->id)->first();
        if($schoolEmployee->current_work_id == 1){
            return response()->json(['error' => trans('api.school manager permissions can not be updated')], 400);
        }

        // Get the list of permissions passed in the request
        $permissions = explode(",", $request->permissions);

        // Find available permissions (check if they exist in the database)
        $availablePermissions = Permission::whereIn('name', $permissions)->pluck('name')->toArray();

        // If there are any invalid permissions, return them
        if (count($availablePermissions) !== count($permissions)) {
            return response()->json([
                'message' => trans('api.Some permissions are invalid'),
                'invalid_permissions' => array_diff($permissions, $availablePermissions),
            ], 400);
        }

        // Initialize an array to hold all permissions to be assigned
        $allPermissionsToAssign = [];

        // Iterate through each permission to get sub-permissions and recursively their sub-permissions
        foreach ($permissions as $permissionName) {
            $allPermissionsToAssign[] = $permissionName;

            // Get the ID of the current permission
            $parentPermission = Permission::where('name', $permissionName)->first();

            // If the permission exists and has sub-permissions, handle them
            if ($parentPermission) {
                // Fetch sub-permissions for the current permission
                $subPermissions = $this->getAllSubPermissions($parentPermission->id);
                // Merge sub-permissions with the main permissions
                $allPermissionsToAssign = array_merge($allPermissionsToAssign, $subPermissions);
            }
        }

        // Remove old permissions from the user and add the new permissions (including sub-permissions)
        $user->syncPermissions([]);
        $user->givePermissionTo($allPermissionsToAssign);

        return response()->json(['message' => trans('api.user permissions updated successfully')]);
    }

    // Recursive function to fetch all sub-permissions (including sub-permissions of sub-permissions)
    private function getAllSubPermissions($parentId){
        // Get all immediate sub-permissions
        $permissions = Permission::where('parent_id', $parentId)->get();
        $allPermissions = [];

        // Loop through each sub-permission and check for their sub-permissions recursively
        foreach ($permissions as $permission) {
            $allPermissions[] = $permission->name;

            // Recursively fetch sub-permissions of sub-permissions
            $subPermissions = $this->getAllSubPermissions($permission->id);
            // Merge sub-permissions into the current list
            $allPermissions = array_merge($allPermissions, $subPermissions);
        }

        return $allPermissions;
    }

    public function getSchoolSystemUsers(Request $request)
    {
        // $token = $request->bearerToken();
        // if ($token) {
        //     $user = JWTAuth::toUser($token);
        // }
        $school = School::find($request->school_id);

        // Start with the base query
        $data = SchoolEmployee::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\AdminDashboard\School\SchoolEmployee', $queryParams);
        }

        if($request->type == 'all'){
            $data->where('school_id', $school->id)->where('have_account', $request->have_account);
        }else{
            $data->where('type', $request->type)->where('school_id', $school->id)->where('have_account', $request->have_account);
        }


        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolEmployeeResource::collection($data->paginate($perPage));

        return response()->json(['system_users' => $filterData, 'message' => trans('api.school system users')]);
    }

    public function removeSystemAccount(Request $request){
        $employee = SchoolEmployee::find($request->system_user_id);

        // Delete related user
        User::where('id', $employee->user_id)->forceDelete();

        $employee->have_account = 'no';
        $employee->save();
        return response()->json(['message'=>trans('api.system user deleted successfully')]);
    }

}
