<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Reports;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\ManagerDashboard\Reports\ManagerReport\AbsentLateReportResource;
use App\Http\Resources\ManagerDashboard\Reports\ManagerReport\AdministrativeWorkReportResource;
use App\Http\Resources\ManagerDashboard\Reports\ManagerReport\TeamCommitteesMeetingResource;
use App\Http\Resources\ManagerDashboard\Reports\ManagerReport\SchoolStatusStatisticsReportResource;
use App\Http\Resources\ManagerDashboard\Reports\SchoolAdminstrativeReport\SchoolAdminstrativeAbsentLateReportResource;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Reports\ManagerReports\AbsentLate;
use App\Models\ManagerDashboard\Reports\ManagerReports\AdministrativeWork;
use App\Models\ManagerDashboard\Reports\ManagerReports\CommitteesMeeting;
use App\Models\ManagerDashboard\Reports\ManagerReports\SchoolStatusStatistic;
use App\Models\ManagerDashboard\Reports\SchoolAdmisnstrativeReport\SchoolAdminstrativeAbsentLate;
use Illuminate\Http\Request;
use JWTAuth;
use Carbon\Carbon;

use App\Models\Namazeg;
use App\Traits\NamazegTrait;


class ManagerReportController extends Controller
{
    use NamazegTrait;

    public function __construct()
    {
        //$this->middleware(['auth:api','permission:school-manager-reports']);
    }

    /* function used to store School Status Statistics Report*/
    public function storeSchoolStatusStatisticsReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        $data = $request->all();
        $data['report_category_id']= 5;
        $data['namazeg_version_id'] = NULL;
        $report = SchoolStatusStatistic::create($data);
        $report = new SchoolStatusStatisticsReportResource($report);

        return response()->json(['report'=>$report,'message' => trans('api.Report has been created!')]);
    }

    /* function used to return School Status Statistics Report by id */
    public function getSchoolStatusStatisticsReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        $report= SchoolStatusStatistic::where('id',$request->report_id)->where('school_id',$school->id)->firstOrFail();
        $report = new SchoolStatusStatisticsReportResource($report);
        return response()->json(['report'=>$report,'message' => trans('api.Report details')]);
    }

    /* function used to return all School Status Statistics Reports */
    public function getSchoolStatusStatisticsReports(Request $request,$schoolId){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }

        $school = School::where('user_id',$user->id)->where('id',$schoolId)->firstOrFail();

        // Start with the base query
        $data = SchoolStatusStatistic::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key, ['per_page', 'date','date_type']);
        }, ARRAY_FILTER_USE_KEY);
        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Reports\ManagerReports\SchoolStatusStatistic', $filterData);
        }
        $data->where('school_id', $school->id);

        // custom filter////
        if ($request->date) {
            $formattedDate = Carbon::createFromFormat('d/m/Y', $request->date)->toDateString();
            $data->whereDate('created_at', $formattedDate)->where('date_type',$request->date_type);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolStatusStatisticsReportResource::collection($data->paginate($perPage));
        return response()->json(['reports'=>$filterData,'message' => trans('api.list of all reports')]);
    }

    public function storeAbsentLateReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        $data = $request->all();
        $data['report_category_id']= 7;
        $data['namazeg_version_id'] = NULL;
        if($request->report_type == 'weekly'){
            $semester= Helper::getCurrentSchoolSemester();
            $data['semester_id'] = $semester->id;
        }
        $report = AbsentLate::create($data);

        /* handel namzeg of each report depend on type*/
        $namazegMappings = [
            'absent_teachers' => [null => 264],
            'late_teachers' => [null => 265],
            'absent_students' => [
                'daily' => 267,
                'weekly' => 268,
                'classy' => 269,
            ],
            'late_students' => [
                'daily' => 270,
                'weekly' => 271,
                'classy' => 272,
            ],
        ];

        $category = $report->report_category;
        $type = $report->report_type ?? null;

        if (isset($namazegMappings[$category])) {
            $namazegId = $namazegMappings[$category][$type] ?? null;
            if ($namazegId) {
                $this->handelNamazeg($report->id, $namazegId);
            }
        }

        $report = new AbsentLateReportResource($report);

        return response()->json(['report'=>$report,'message' => trans('api.Report has been created!')]);
    }

    /* function used to return School Status Statistics Report by id */
    public function getAbsentLateReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        $report= AbsentLate::where('id',$request->report_id)->where('school_id',$school->id)->firstOrFail();
        $reportCategory = $report->report_category;
        $report = new AbsentLateReportResource($report);
        return response()->json(['report'=>$report,'report_category'=>$reportCategory,'message' => trans('api.Report details')]);
    }

    public function getAbsentLateReports(Request $request,$schoolId){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$schoolId)->firstOrFail();

        // Start with the base query
        $data = AbsentLate::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key, ['per_page', 'date','date_type','report_type','report_category']);
        }, ARRAY_FILTER_USE_KEY);
        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Reports\ManagerReports\AbsentLate', $filterData);
        }
        $data->where('school_id', $school->id);

        // custom filter////
        if ($request->date) {
            $formattedDate = Carbon::createFromFormat('d/m/Y', $request->date)->toDateString();
            $data->whereDate('created_at', $formattedDate)->where('date_type',$request->date_type);
        }

        if ($request->report_category) {
            $data->where('report_category', $request->report_category);
        }

        if ($request->report_type) {
            $data->where('report_type', $request->report_type);
        }
        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = AbsentLateReportResource::collection($data->paginate($perPage));
        return response()->json(['reports'=>$filterData,'message' => trans('api.list of all reports')]);
    }


    public function storeAdministrativeWorkReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',$request->current_work_id)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $data = $request->all();
        $data['report_category_id']= 8;
        $data['namazeg_version_id'] = NULL;
        $report = AdministrativeWork::create($data);

        $report = new AdministrativeWorkReportResource($report);

        return response()->json(['report'=>$report,'message' => trans('api.Report has been created!')]);
    }

    public function getAdministrativeWorkReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        $report= AdministrativeWork::where('id',$request->report_id)->where('school_id',$school->id)->firstOrFail();
        $reportCategory = '';
        if($report->current_work_id == 6){
            $reportCategory = 'educational_adminstrative_works';
        }

        if($report->current_work_id == 7){
            $reportCategory = 'students_adminstrative_works';
        }
        if($report->current_work_id == 8){
            $reportCategory = 'school_adminstrative_works';
        }
        $report = new AdministrativeWorkReportResource($report);
        return response()->json(['report'=>$report,'report_category'=>$reportCategory,'message' => trans('api.Report details')]);
    }

    public function getAllAdministrativeWorkReports(Request $request,$schoolId){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$schoolId)->firstOrFail();
        $reports= AdministrativeWork::where('school_id',$school->id)->get();
        $reports =  AdministrativeWorkReportResource::collection($reports);

        // Start with the base query
        $data = AdministrativeWork::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key, ['per_page', 'date','date_type','report_type','report_category']);
        }, ARRAY_FILTER_USE_KEY);
        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Reports\ManagerReports\AdministrativeWork', $filterData);
        }
        $data->where('school_id', $school->id);

        // custom filter////
        if ($request->date) {
            $formattedDate = Carbon::createFromFormat('d/m/Y', $request->date)->toDateString();
            $data->whereDate('created_at', $formattedDate)->where('date_type',$request->date_type);
        }

        if ($request->report_category) {
            $data->where('report_category', $request->report_category);
        }

        if ($request->report_type) {
            $data->where('report_type', $request->report_type);
        }
        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = AdministrativeWorkReportResource::collection($data->paginate($perPage));
        return response()->json(['reports'=>$filterData,'message' => trans('api.list of all reports')]);
    }

    public function storeCommitteesMeetingsReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        $data = $request->all();
        $data['report_category_id']= 6;
        $data['namazeg_version_id'] = NULL;
        $report = CommitteesMeeting::create($data);
        $report = new TeamCommitteesMeetingResource($report);

        return response()->json(['report'=>$report,'message' => trans('api.Report has been created!')]);

    }

    public function getCommitteesMeetingsReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $report= CommitteesMeeting::where('id',$request->report_id)->where('school_id',$school->id)->firstOrFail();
        $report = new TeamCommitteesMeetingResource($report);
        return response()->json(['report'=>$report,'message' => trans('api.Report details')]);

    }

    public function getAllCommitteesMeetingsReports(Request $request,$schoolId){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$schoolId)->firstOrFail();

        // Start with the base query
        $data = CommitteesMeeting::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key, ['per_page', 'date','date_type']);
        }, ARRAY_FILTER_USE_KEY);
        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Reports\ManagerReports\CommitteesMeeting', $filterData);
        }
        $data->where('school_id', $school->id);

        // custom filter////
        if ($request->date) {
            $formattedDate = Carbon::createFromFormat('d/m/Y', $request->date)->toDateString();
            $data->whereDate('created_at', $formattedDate)->where('date_type',$request->date_type);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = TeamCommitteesMeetingResource::collection($data->paginate($perPage));

        return response()->json(['reports'=>$filterData,'message' => trans('api.list of all reports')]);
    }


    private function handelNamazeg($reportId,$formNumber){
        $report = AbsentLate::find($reportId);
        /** create or update  namozg version for this table*/
        $namozeg = Namazeg::where('form_number', $formNumber)->first();
        $namazeg_version_id = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $report->school_id
        )->id;

        /* store namozeg version for this record*/
        $report->update(['namazeg_version_id' => $namazeg_version_id]);
    }

}
