<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Notification;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use App\Http\Resources\ManagerDashboard\Notification\NotificationResource;
use App\Http\Resources\ManagerDashboard\Notification\NotificationSettingResource;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\NotificationSettings\NotificationSchoolSetting;
use Illuminate\Http\Request;

use Tymon\JWTAuth\Facades\JWTAuth;

class NotificationSettingsController extends Controller
{

    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify', 'permission:notifications']);
    }

 
    public function getAll(School $school)    
    {
        $notifications = NotificationSchoolSetting::with('notification_name')->where("school_id", $school->id)->get();
        $notifications_resource = NotificationSettingResource::collection($notifications);
        return response()->json([
            'notifications' => $notifications_resource
        ]);
    }
    public function status(NotificationSchoolSetting $setting, Request $request){
        $setting->update([$request->type=> !$setting->{$request->type}]);
        return response()->json([
            'message' => __('api.update')
        ]);
    }
    public function get_messages_all_status(School $school,Request $request){
        $status_check = NotificationSchoolSetting::where('school_id', $school->id)
            ->where('messages_disability',0)
            ->where('messages',1)
            ->first();
        return response()->json([
            'status' => $status_check?1:0
        ]);
    }
    public function messages_all_status(School $school,Request $request){
        NotificationSchoolSetting::where('school_id', $school->id)
            ->where('messages_disability',0)
            ->update(['messages'=> $request->status]);
        return response()->json([
            'message' => __('api.update')
        ]);
    }
}
