<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Notification;

use App\Helpers\Helper;
use App\Helpers\HelperNotification;
use App\Http\Controllers\Controller;
use App\Http\Requests\Notification\NotificationStoreRequest;
use App\Http\Requests\Notification\NotificationUpdateRequest;
use App\Models\Notification;
use App\Http\Resources\ManagerDashboard\Notification\NotificationResource;

use App\Models\AdminDashboard\School\School;
use App\Models\Event;
use App\Models\NotificationReceptor;
use App\Models\User;
use App\Traits\LogsActivity;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use Tymon\JWTAuth\Facades\JWTAuth;

class NotificationController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify', 'permission:notifications']);
    }

    // -for alerts of header  for all suers  Count
    public function topCount(Request $request)
    {
        $user = JWTAuth::parseToken()->authenticate();
        if (!$user) {
            return response()->json([
                'message' => 'User not authenticated'
            ], 401);
        }
        $count_unopened = $user->my_bell_count_notification($request->school_id)
            ->where('seen', 0)
            ->where('open', 0)
            ->count();
        return response()->json([
            'n_notifications' => $count_unopened
        ]);
    }

    // -for alerts of header  for all suers 
    public function top_notifications(Request $request)
    {
        $user = JWTAuth::parseToken()->authenticate();
        if (!$user) {
            return response()->json([
                'message' => 'User not authenticated'
            ], 401);
        }
        $grouped_notifications = $user->my_bell_notification($request->school_id)
            ->where('seen', 0)
            ->latest()
            ->take(20)
            ->get()
            ->groupBy('notification.type');
        $formatted_notifications = $grouped_notifications->map(function ($notifications, $type) {
            return NotificationResource::collection($notifications);
        });

        $user->my_bell_notification($request->school_id)->where('seen', 0)->update(['open' => 1, 'seen' => 1]);

        return response()->json([
            'my_notifications' => $formatted_notifications

        ]);
    }

    public function bar_type(Request $request)
    {
        $user = JWTAuth::parseToken()->authenticate();
        $userTypes =  explode(',', $user->user_type);
        if (!in_array('super_admin', $userTypes) && $user->employee) {
            $helperNotification = new HelperNotification($user);
            if (count($user->user_schools) > 0) {
                if ($user->employee?->current_work_id == 1) {
                    $helperNotification->manager_notifications($request->school_id);
                }
            }
        }
        $notifications = $user->my_priority_tape_notification($request->school_id)->latest()->get();
        $notifications->map(function ($notification) {
            $notification->update(['seen' => 1]);
        });

        $my_notifications = NotificationResource::collection($notifications);

        return $my_notifications;
    }

    // -for All alerts of Show more in header for all suers 
    public function getAll(Request $request)
    {
        $user = JWTAuth::parseToken()->authenticate();
        if (!$user) {
            return response()->json([
                'message' => 'User not authenticated'
            ], 401);
        }
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $user->my_all_notification()
            ->update(['seen' => 1]);
        $my_notifications = NotificationResource::collection(
            $user->my_all_notification($request->school_id)
                ->latest()
                ->orderBy('updated_at', 'Desc')
                ->paginate($perPage)
        );

        return response()->json([
            'data' => $my_notifications,
            'pagination' => [
                'current_page' => $my_notifications->currentPage(),
                'last_page' => $my_notifications->lastPage(),
                'total' => $my_notifications->total(),
                'per_page' => $my_notifications->perPage(),
            ]
        ]);
    }

    public function getById($id)
    {
        $notification = Notification::findOrFail($id);
        $notification->update(['seen' => 1]);
        $notification = new NotificationResource($notification);
        return response()->json(['notification' => $notification, 'message' => trans('api.page details')]);
    }

    public function archive(School $school)
    {
        $user = JWTAuth::parseToken()->authenticate();
        if (!$user) {
            return response()->json([
                'message' => 'User not authenticated'
            ], 401);
        }
        $user->my_bell_notification()->where('school_id', $school->id)->update(['seen' => 1, 'open' => 1]);
        return response()->json(['message' => trans('api.record archived successflly')]);
    }
}
