<?php

namespace App\Http\Controllers\Api\ManagerDashboard;

use Alkoumi\LaravelHijriDate\Hijri;
use App\Helpers\Helper;
use App\Helpers\HelperNotification;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Search\SearchRequest;
use App\Http\Resources\AdminDashboard\ExternalSystem\ExternalSystemResource;
use App\Http\Resources\AdminDashboard\Logs\LogResource;
use App\Http\Resources\Event\EventResource;
use App\Http\Resources\ManagerDashboard\Notification\NotificationResource;
use App\Http\Resources\ManagerDashboard\Tasks\TaskResource;
use App\Http\Resources\Slider\SliderResource;
use App\Models\AdminDashboard\ExternalSystem\ExternalSystem;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\Event;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\ManagerDashboard\Settings\Subscription;
use App\Models\ManagerDashboard\Tasks\Task;
use App\Models\Namazeg;
use App\Models\Slider;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Spatie\Activitylog\Models\Activity;
use Tymon\JWTAuth\Facades\JWTAuth;

class HomeController extends Controller
{
    const CONSTANT_SEARCH = [
        [
            "name" => ["بيانات المدرسة", "School data"],
            "form_number" => 1001
        ],
        [
            "name" => ["بيانات عامة", "General data"],
            "form_number" => 1002
        ],
        [
            "name" => ["بيانات مرافق المدرسة", "School facilities data"],
            "form_number" => 1003
        ],
        [
            "name" => ["بيانات الطلاب", "Students data"],
            "form_number" => 1004
        ],
        [
            "name" => ["بيانات المعلمين", "Teachers data"],
            "form_number" => 1005
        ],
        [
            "name" => ["بيانات الإداريين", "Administrators data"],
            "form_number" => 1006
        ],
        [
            "name" => ["بيانات أخرى", "Other data"],
            "form_number" => 1007
        ],
        [
            "name" => ["طلاب المدرسة", "School students"],
            "form_number" => 1008
        ],
        [
            "name" => ["معلمي المدرسة", "School teachers"],
            "form_number" => 1009
        ],
        [
            "name" => ["إداري المدرسة", "School administrator"],
            "form_number" => 1010
        ],
        [
            "name" => ["التكليفات", "Assignments"],
            "form_number" => 1011
        ],
        [
            "name" => ["اجتماعات اللجان والفرق", "Committee and team meetings"],
            "form_number" => 1012
        ],
        [
            "name" => ["الخطابات الرسمية", "Official letters"],
            "form_number" => 1013
        ],
        [
            "name" => ["الجداول", "Tables"],
            "form_number" => 1014
        ],
        [
            "name" => ["جدول المناوبة", "Shift schedule"],
            "form_number" => 1015
        ],
        [
            "name" => ["جدول الإشراف", "Supervision schedule"],
            "form_number" => 1016
        ],
        [
            "name" => ["جدول الزيارات الصفية المتبادلة", "Summer visit schedule"],
            "form_number" => 1017
        ],
        [
            "name" => ["جدول الإختبارات", "Test schedule"],
            "form_number" => 1018
        ],
        [
            "name" => ["جدول تأمين حصص الإنتظار", "Waiting class schedule"],
            "form_number" => 1019
        ],
        [
            "name" => ["جدول المعلمين", "Teachers schedule"],
            "form_number" => 1020
        ],
        [
            "name" => ["الزيارات الصفية", "Class visits"],
            "form_number" => 1021
        ],
        [
            "name" => ["الإختبارات", "Exams"],
            "form_number" => 1022
        ],
        [
            "name" => ["لجان الإشراف على الاختبارات", "Test supervision committees"],
            "form_number" => 1023
        ],
        [
            "name" => ["لجان الاختبارات للطلاب", "Examination committees students"],
            "form_number" => 1024
        ],
        [
            "name" => ["نماذج خطة الاختبارات", "Test plan templates"],
            "form_number" => 1025
        ],
        [
            "name" => ["السلوك", "Behavior"],
            "form_number" => 1026
        ],
        [
            "name" => ["المواظبة", "Attendance"],
            "form_number" => 1027
        ],
        [
            "name" => ["النماذج", "Models"],
            "form_number" => 1028
        ],
        [
            "name" => ["الأدلة واللوائح", "Guides and regulations"],
            "form_number" => 1029
        ],
        [
            "name" => ["مدير المدرسة", "School manager"],
            "form_number" => 1030
        ],
        [
            "name" => ["الشؤون التعليمية", "Educational affairs"],
            "form_number" => 1031
        ],
        [
            "name" => ["شؤون الطلاب", "Students affairs"],
            "form_number" => 1032
        ],
        [
            "name" => ["الشؤون المدرسية", "School affairs"],
            "form_number" => 1033
        ],
        [
            "name" => ["أغلفة السجلات", "Record covers"],
            "form_number" => 1034
        ],
        [
            "name" => ["التقارير", "Reports"],
            "form_number" => 1035
        ],
        [
            "name" => ["الرسائل والتنبيهات", "Messages and alerts"],
            "form_number" => 1036
        ],
        [
            "name" => ["الأرشيف", "Archive"],
            "form_number" => 1037
        ],
        [
            "name" => ["سلة المحذوفات", "Recycle bin"],
            "form_number" => 1038
        ],
        [
            "name" => ["الإعدادات", "Settings"],
            "form_number" => 1039
        ],
        [
            "name" => ["إعدادات عامة", "General settings"],
            "form_number" => 1040
        ],
        [
            "name" => ["إعدادات الادرايين", "Administrators settings"],
            "form_number" => 1041
        ],
        [
            "name" => ["إعدادات التنبيهات", "Notification settings"],
            "form_number" => 1042
        ],
        [
            "name" => ["إعدادات المعلمين", "Teacher settings"],
            "form_number" => 1043
        ],
        [
            "name" => ["إعدادات الاشتراكات والفواتير", "Subscription and billing"],
            "form_number" => 1044
        ]
    ];
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify','permission:manger-dashboard']);
    }


    public function index(School $school, Request $request)
    {
        $user = JWTAuth::parseToken()->authenticate();
        $userTypes =  explode(',', $user->user_type);
        if (!in_array('super_admin', $userTypes) && $user->employee) {
            $helperNotification = new HelperNotification($user);
            if (count($user->user_schools) > 0) {
                $school_id = $school->id;
                if ($user->employee?->current_work_id == 1) {
                    $helperNotification->manager_notifications($school_id);
                    $helperNotification->create_vioaltions_actions_needed_notifications($school_id);
                } elseif ($user->employee?->current_work_id == 6) {
                    // وكيل الشئون التعليمية// انشاء زيارات صفية فى بداية كل فصل دراسى
                    $helperNotification->create_class_room_visits_notifications($school_id);
                    $helperNotification->create_vioaltions_actions_needed_notifications($school_id);
                } elseif ($user->employee?->current_work_id == 7) {
                    // وكيل الشئون الطلاب
                    // انشاء زيارات صفية فى بداية كل فصل دراسى
                    $helperNotification->create_uncomplete_exame_committe_notifications($school_id);
                    $helperNotification->create_vioaltions_actions_needed_notifications($school_id);
                    $helperNotification->create_create_exame_committe_notifications($school_id);
                    $helperNotification->create_absence_actions_needed_notifications($school_id);
                }
                // الاجتماع غير مكتمل ومر 24 ساعة على تاريخ الاجتماع لرئيس اللجنه
                $helperNotification->create_not_complete_meetings_notifications($school_id);

                // انشاء جدول اختبارات
                $helperNotification->create_exame_notifications($school_id);
            }
        } else {
            $helperNotification = new HelperNotification($user);
        }
        if (is_null($user->email_verified_at)) {
            $helperNotification->is_email_verified($school->id);
        }


        $subscribtion = Subscription::with('product')->where('user_id', $user->id)
            ->where('paid_status', 'paid')
            ->where('status', 'subscribed')->latest()->first();
        if ($subscribtion && $subscribtion->product->messages_count > 0) {
            $remaining = $subscribtion->product->messages_count - $subscribtion->messages_consumed;
            $remaining_m_percentage = $remaining / $subscribtion->product->messages_count * 100;
        } else {
            $remaining_m_percentage = 0;
        }
        $data['remaining_m_percentage'] = $remaining_m_percentage;

        $today = Carbon::now()->format('d/m/Y');
        // notifications

        $notifications = $user->my_normal_tape_notification($school->id)->latest()->get();
        $notifications->map(function ($notification) {
            $notification->update(['seen' => 1]);
        });

        $my_notifications = NotificationResource::collection($notifications);
        $data['normal_tape_notification'] = $my_notifications;

        $current_semester = Helper::getCurrentToLastSchoolSemester($today);
        if ($current_semester->id != 4) {
            // semester days
            $semesterWeekDays = SemesterWeekDay::with('week')->where('semester_id', $current_semester->id)->get();
            // today
            $semesterWeekDay = $semesterWeekDays->where('date', $today)->first();

            $current_stats['current_semester'] = $current_semester->name;
            $current_stats['current_week'] = $semesterWeekDay ? $semesterWeekDay->week->name : 'نهاية ' . $current_semester->name;

            $firstRecord = $semesterWeekDays->where('id', $semesterWeekDays->min('id'))->first();
            $lastRecord = $semesterWeekDays->where('id', $semesterWeekDays->max('id'))->first();
            $firstDate = Carbon::createFromFormat('d/m/Y', $firstRecord->date)->format('d/m/Y');
            $lastDate = Carbon::createFromFormat('d/m/Y', $lastRecord->date)->format('d/m/Y');


            $holidays = Event::where('holiday', 1)
                ->where(function ($query) use ($firstDate, $lastDate) {
                    $query->whereRaw(
                        "STR_TO_DATE(date_from, '%d/%m/%Y') BETWEEN STR_TO_DATE(?, '%d/%m/%Y') AND STR_TO_DATE(?, '%d/%m/%Y')",
                        [$firstDate, $lastDate]
                    )
                        ->orWhereRaw(
                            "STR_TO_DATE(date_to, '%d/%m/%Y') BETWEEN STR_TO_DATE(?, '%d/%m/%Y') AND STR_TO_DATE(?, '%d/%m/%Y')",
                            [$firstDate, $lastDate]
                        )
                        ->orWhereRaw(
                            "(STR_TO_DATE(date_from, '%d/%m/%Y') <= STR_TO_DATE(?, '%d/%m/%Y') AND STR_TO_DATE(date_to, '%d/%m/%Y') >= STR_TO_DATE(?, '%d/%m/%Y'))",
                            [$lastDate, $firstDate]
                        );
                })
                ->get();
            $totalDays = 0;
            $allHolidayDates = [];

            // Collect all dates from holidays within their ranges
            foreach ($holidays as $holiday) {
                $eventStart = Carbon::createFromFormat('d/m/Y', $holiday->date_from);
                $eventEnd = Carbon::createFromFormat('d/m/Y', $holiday->date_to);

                // Generate all dates within the holiday range
                while ($eventStart <= $eventEnd) {
                    $allHolidayDates[] = $eventStart->copy(); // Clone the date and add it to the list
                    $eventStart->addDay(); // Increment to the next day
                }
            }
            $semesterRangeStart = Carbon::createFromFormat('d/m/Y', $firstRecord->date);
            $semesterRangeEnd = Carbon::createFromFormat('d/m/Y', $lastRecord->date);
            $today_format = $semesterWeekDay ? Carbon::createFromFormat('d/m/Y', $semesterWeekDay?->date) : today();
            $holidays_in_remaining = 0;

            foreach ($allHolidayDates as $holidayDate) {
                if ($holidayDate->between($semesterRangeStart, $semesterRangeEnd)) {
                    $totalDays++;
                }
                if ($holidayDate->between($today_format, $semesterRangeEnd)) {
                    $holidays_in_remaining++;
                }
            }
            $allHolidayCount = $totalDays;
            $firstDay = Carbon::createFromFormat('d/m/Y', $firstRecord->date);
            $lastDay = Carbon::createFromFormat('d/m/Y', $lastRecord->date);
            $allDays = 0;
            $fridaysAndSaturdaysCount_in_remaining = 0;

            // Loop through each date in the range
            while ($firstDay <= $lastDay) {
                if (!in_array($firstDay->dayOfWeek, [Carbon::FRIDAY, Carbon::SATURDAY])) {
                    $allDays++;
                } elseif ($firstDay >= $today_format) {
                    $fridaysAndSaturdaysCount_in_remaining++;
                }
                $firstDay->addDay(); // Move to the next day
            }

            $firstDay = Carbon::createFromFormat('d/m/Y', $firstRecord->date);
            $lastDay = Carbon::createFromFormat('d/m/Y', $lastRecord->date);

            // $allDays = $semesterWeekDay ? $lastDay->diffInDays($firstDay) : 0;

            $remaining_days = $semesterWeekDay ? $lastDay->diffInDays($today_format) : 0;

            $current_stats['allDays'] = $allDays - $allHolidayCount; // all days without fridays and saturdays and holidays
            $current_stats['remaining_days'] = $remaining_days - $fridaysAndSaturdaysCount_in_remaining - $holidays_in_remaining; // all days without fridays and saturdays



        } elseif ($current_semester->id == 4) {
            $current_stats['current_semester'] =  'عطلة نهاية السنه';
            $current_stats['current_week'] = 'اسبوع فى عطلة نهاية السنه';
            $current_stats['allDays'] = 0;
            $current_stats['remaining_days'] = 0;
        }

        $date_hijri = Hijri::Date('l ، j F ، Y');
        $date_coptic = Carbon::now()->translatedFormat('d F Y');
        $current_stats['date_coptic'] = $date_coptic;
        $current_stats['date_hijri'] = $date_hijri;
        $data['current_stats'] = $current_stats;
        // // sliders
        $sliders = Slider::whereRaw("STR_TO_DATE(start_date, '%d/%m/%Y') <= STR_TO_DATE(?, '%d/%m/%Y')", [$today])
            ->whereRaw("STR_TO_DATE(end_date, '%d/%m/%Y') >= STR_TO_DATE(?, '%d/%m/%Y')", [$today])
            ->get();
        $slider_resource = SliderResource::collection($sliders);
        $data['sliders'] = $slider_resource;
        // // numbers
        $n_classes = count($school->classes);
        $n_teachers = count($school->employees->where('type', 'teacher'));
        $n_employees = count($school->employees->where('type', '!=', 'teacher'));
        $n_students = count($school->students);

        $students_attendances = $school->students_attendance->where('date', $today);
        $n_students_attended = count($students_attendances->where('status', 'attended'));
        $n_students_absent = count($students_attendances->whereNotIn('status', [null, 'attended']));


        $teachers_attendance = $school->teachers_attendance->where('date', $today);
        $n_teachers_absent = count($teachers_attendance->where('status', 'absent'));
        $n_teachers_attended = count($teachers_attendance->where('status', '!=', 'absent'));
        $numbers = [
            'n_classes' => $n_classes,
            'n_teachers' => $n_teachers,
            'n_employees' => $n_employees,
            'n_students' => $n_students,
            'n_students_attended' => $n_students_attended,
            'n_students_absent' => $n_students_absent,
            'n_teachers_attended' => $n_teachers_attended,
            'n_teachers_absent' => $n_teachers_absent,
        ];
        $data['numbers'] = $numbers;

        $events = Event::whereRaw("STR_TO_DATE(date_from, '%d/%m/%Y') <= STR_TO_DATE(?, '%d/%m/%Y')", [$today])
            ->whereRaw("STR_TO_DATE(date_to, '%d/%m/%Y') >= STR_TO_DATE(?, '%d/%m/%Y')", [$today])
            ->get();
        $data['events'] = EventResource::collection($events);

        $tasks = Task::where(function ($query) use ($school) {
            $query->where('school_id', $school->id)
                ->orWhereNull('school_id');
        });
        if ($request->year && $request->month) {
            $tasks = $tasks->whereRaw(
                'YEAR(STR_TO_DATE(date, "%d/%m/%Y")) = ? AND MONTH(STR_TO_DATE(date, "%d/%m/%Y")) = ?',
                [$request->year, $request->month]
            );
        } else {
            $tasks = $tasks->whereRaw(
                'YEAR(STR_TO_DATE(date, "%d/%m/%Y")) = ? AND MONTH(STR_TO_DATE(date, "%d/%m/%Y")) = ?',
                [date('Y'), date('m')]
            );
        }
        $tasks = $tasks->get();
        $groupedTasks = $tasks->groupBy(function ($task) {
            return $task->date; // Group by date
        });

        $data['tasks'] = $groupedTasks->map(function ($groupedTask, $date) {
            $task_resources = TaskResource::collection($groupedTask);
            return [
                'date' => Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d'),
                'date_ar' => Carbon::createFromFormat('d/m/Y', $date)->translatedFormat('d F Y'),
                'n_tasks' => count($task_resources),
                'data' => $task_resources,
            ];
        })->values();

        // $tasks_resource = TaskResource::collection($tasks);
        // $data['tasks'] = $tasks_resource;
        $logs = Activity::with('causer')->orderBy('created_at', 'Desc')
            ->whereJsonContains('properties->school_id', (string) $school->id);
        if ($request->year && $request->month) {
            $logs = $logs->whereYear('created_at', $request->year)
                ->whereMonth('created_at', $request->month);
        } else {
            $logs = $logs->whereYear('created_at', date('Y'))
                ->whereMonth('created_at', date('m'));
        }
        $logs = $logs->take(20)->get();
        $groupedLogs = $logs->groupBy(function ($log) {
            return $log->created_at->format('Y-m-d'); // Group by date
        });

        $data['logs'] = $groupedLogs->map(function ($logs, $date) {
            return [
                'date' => $date,
                'data' => LogResource::collection($logs),
            ];
        })->values();


        $externalSystem = ExternalSystem::where('status', 1)->get();
        $externalSystem_resource = ExternalSystemResource::collection($externalSystem);
        $data['external_system'] = $externalSystem_resource;

        return response()->json($data);
    }
    public function general_search(School $school, SearchRequest $request)
    {
        $request_data = trim($request->data);
        $request_data = str_replace('#', '', $request_data);

        // Fetch records from Namazeg
        $real_namazeg = Namazeg::where('form_number', 'like', '%' . $request_data . '%')
            ->orWhere('name', 'like', '%' . $request_data . '%')
            ->select('name', 'form_number')
            ->get();

        // Fetch records from NamazegVersion
        $version_namazeg = NamazegVersion::with([
            'namozeg' => function ($query) {
                $query->select('id', 'name', 'form_number');
            }
        ])->where('serial_number', 'like', '%' . $request_data . '%')->get()
            ->map(function ($version) {
                return [
                    'name' => $version->namozeg?->name,
                    'form_number' => $version->namozeg?->form_number,
                ];
            })->unique()->values();

        $constant_results = self::CONSTANT_SEARCH;
        $filtered_results = array_filter($constant_results, function ($item) use ($request_data) {
            if (is_array($item['name'])) {
                foreach ($item['name'] as $name) {
                    if (stripos($name, $request_data) !== false) {
                        return true; // Return true if a match is found
                    }
                }
            } else {
                if (stripos($item['name'], $request_data) !== false) {
                    return true; // Return true if a match is found
                }
            }

            return false; // No match found
        });
        $filtered_results = collect(array_values($filtered_results));

        $combined_results = $real_namazeg
            ->concat($version_namazeg)
            ->concat($filtered_results)
            ->unique(function ($item) {
                $name = is_array($item['name']) ? implode(',', $item['name']) : $item['name'];
                return $name . $item['form_number'];
            })
            ->values();

        $matched_results = $combined_results->map(function ($item) use ($request_data) {
            if (is_array($item['name'])) {
                foreach ($item['name'] as $name) {
                    if (stripos($name, $request_data) !== false) {
                        $item['name'] = $name;
                        break;
                    }
                }
            }
            return $item;
        });

        // return only one name
        $matched_results = $matched_results->filter(function ($item) use ($request_data) {
            if (is_array($item['name'])) {
                return stripos($item['name'], $request_data) !== false || stripos($item['form_number'], $request_data) !== false;
            } else {
                return $item;
            }
        });
        return response()->json($matched_results->values());
    }
}
