<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Exams\StudentCommittees;

use Alkoumi\LaravelHijriDate\Hijri;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Exams\StudentCommittes\StoreCommitteeDataRequest;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommittee;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommitteeData;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentSeatingNumber;
use Illuminate\Http\Request;

class CommitteeDataController extends Controller
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(StoreCommitteeDataRequest $request, School $school, StudentCommittee $committee)
    {
        $data = $request->validated();
        // Ensure the committee belongs to the specified school
        $committee = $committee->where('id',$committee->id)->where('school_id', $school->id)->firstOrFail();


        foreach ($data['schoolClasses'] as $schoolClass) {

            $committeeData = StudentCommitteeData::create(
                [
                    'committee_id' => $committee->id,
                    'schoolclass_id' => $schoolClass['id'],

                    'location' => $data['location'],
                    'student_ids' => json_encode($schoolClass['student_ids']),
                    ]

                );

                // Decode student IDs
            $studentIds = json_decode($committeeData->student_ids);

                // Clear existing seat numbers for this committee
            // StudentSeatingNumber::where('committee_id', $committee->id)->forceDelete();

            // SeatNumber
            $current_year = substr(Hijri::Date('Y'), -2);
            $schoolClass_id = $committeeData->schoolclass_id;
            $classNumber = $committeeData->SchoolClass->class_number;

            // Create new seating numbers for each student
            foreach ($studentIds as $studentId) {
                $baseSeatNumber = "{$current_year}{$schoolClass_id}{$classNumber}{$studentId}";

                // Check if the student already has a seat number in the committee
                    // $existingSeating = StudentSeatingNumber::where('semester_id', $committee->semester->id)
                    // ->where('student_id', $studentId)
                    // ->where('school_id', $school->id)
                    // ->first();
                    // if ($existingSeating) {
                    //     // Return an error message if the student already exists in the committee with a seat number
                    //     return response()->json([
                    //         'error' => "مقيد بالفعل للجنة ولديه رقم جلوس خاص به  هذا الطالب {$studentId}"
                    //     ], 400); // HTTP 400 Bad Request
                    // }
                StudentSeatingNumber::updateOrCreate([
                    'school_id' =>  $school->id,
                    'semester_id' =>  $committee->semester->id,
                    'student_id' => $studentId,
                    'committee_id' => $committee->id,
                    'seat_number' => $baseSeatNumber
                ]);
            }
        }

        $committee->update(['status'=>'complated']);

        return response()->json(['message' => trans('api.record stored successfully')]);
    }
}
