<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Exams\NamazegPlans;

use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\TeacherDeclaration\StoreTeacherCurriculumDeclarationRequest;
use App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\TeacherDeclaration\UpdateTeacherCurriculumDeclarationRequest;
use App\Http\Resources\ManagerDashboard\Exams\NamazegPlans\TeacherCurriculumDeclarationResource;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Exams\NamazegPlans\TeacherDeclaration\TeacherCurriculumDeclaration as TeacherDeclarationTeacherCurriculumDeclaration;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class TeacherCurriculumDeclaration extends Controller
{
    use NamazegTrait;
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request, School $school)
    {
        $queryParams = $request->query();
        // $perPage = $queryParams['per_page'] ?? 15;
        $assignment = TeacherDeclarationTeacherCurriculumDeclaration::with('namozegVersion', 'employee')->where('school_id', $school->id)->get();
        $assignment_resource = TeacherCurriculumDeclarationResource::collection($assignment);
        return response()->json([
            'data' => $assignment_resource
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreTeacherCurriculumDeclarationRequest $request, School $school)
    {
        $data = $request->validated();

        try {
            $namozeg = Namazeg::where('form_number', 75)->firstOrFail();
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'Namozeg Not Found for this committee form number in namazeg table .'], 404);
        }

        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school->id
        );

        TeacherDeclarationTeacherCurriculumDeclaration::create(
            [
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school->id,
                'teacher_id' => $data['teacher_id']
            ]
        );

        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    /**
     * Display the specified resource.
     */
    public function show(School $school, TeacherDeclarationTeacherCurriculumDeclaration  $assignment)
    {
        $assignment_resource = new TeacherCurriculumDeclarationResource($assignment);
        return response()->json([
            'data' => $assignment_resource
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateTeacherCurriculumDeclarationRequest $request,  School $school, TeacherDeclarationTeacherCurriculumDeclaration $assignment)
    {
        $data = $request->validated();

        if ($assignment->school_id !== $school->id) {
            return response()->json(['errors' => trans('لم يتم العثور علي هذا التكليف لهذه المدرسه')], 404);
        }

        $assignment->update(['teacher_id' => $data['teacher_id']]);

        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(School $school, TeacherDeclarationTeacherCurriculumDeclaration $assignment)
    {
        if ($assignment->school_id == $school->id) {
            $assignment->delete();
        }

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
}
