<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Exams\NamazegPlans;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\MonitorDistribtionAssignment\StoreDistribtionAssignmentRequest;
use App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\MonitorDistribtionAssignment\UpdateDistribtionAssignmentRequest;
use App\Http\Resources\ManagerDashboard\Exams\NamazegPlans\MonitorDistribtionAssignmentResource;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Exams\NamazegPlans\MonitorDistributions\DistribtionAssignmentMonitor;
use App\Models\ManagerDashboard\Exams\NamazegPlans\MonitorDistributions\DistributionAssignment;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class MonitorAssignmentDistribtionController extends Controller
{
    use NamazegTrait;

    /**
     * Display a listing of the resource.
     */
    public function index(School $school)
    {
        $distribtionAssignments = DistributionAssignment::with('monitors')->where('school_id', $school->id)->get();

        $assignmentResource = MonitorDistribtionAssignmentResource::collection($distribtionAssignments);

        return response()->json(['data' => $assignmentResource]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreDistribtionAssignmentRequest $request, School $school)
    {

        $dataValidation =  $request->validated();

        $semester = Helper::getCurrentSchoolSemester();
        if(!$semester) {
            return response()->json(['error' => trans('api.there is no semester registered for this date')],404);
        }
       
        try {
            $namozeg = Namazeg::where('form_number', 81)->firstOrFail();
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'Namozeg Not Found for this committee form number in namazeg table .'], 404);
        }


        // Check if a NamazegVersion already exists for the school and namozeg_id
        $existing_version = NamazegVersion::where('namazeg_id', $namozeg->id)
            ->where('school_id', $school->id)
            ->first();

        if (!$existing_version) {
            // If no version exists, create a new one using the trait method
            $namozeg_version = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $school->id
            );
        } else {
            // Use the existing version
            $namozeg_version = $existing_version;
        }

        $assignment = DistributionAssignment::updateOrCreate(
            [
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school->id,
                'semester_id' => $dataValidation['data']['semester_id'] ??  $semester->id,
            ]
        );

        DistribtionAssignmentMonitor::where('md_assignment_id', $assignment->id)->forceDelete();

        foreach ($dataValidation['data']['employees'] as $assignmentData) {
            $date = Carbon::createFromFormat('d/m/Y', $assignmentData['date'])->format('d/m/Y');

            $date_type = $assignmentData['date_type'];

            if ($date_type === 'hijri') {
                $date = Helper::getCoptic($date);
                $date_type = 'coptic';
            }

            DistribtionAssignmentMonitor::create(
                [
                    'md_assignment_id' =>  $assignment->id,
                    'employee_id' => $assignmentData['employee_id'],
                    'date' => $date,
                    'date_type' => $date_type,
                    'period' =>  json_encode($assignmentData['period'])
                ]
            );
        }
        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateDistribtionAssignmentRequest $request, School $school, DistributionAssignment $assignment)
    {
        $dataValidation = $request->validated();

        if ($assignment->school_id !== $school->id) {
            return response()->json(['errors' => trans('لم يتم العثور علي هذا التكليف لهذه المدرسه')], 404);
        }
        
        $assignment->update(['semester_id'=> $dataValidation['data']['semester_id']]);

        DistribtionAssignmentMonitor::where('md_assignment_id', $assignment->id)->forceDelete();

        foreach ($dataValidation['data']['employees'] as $assignmentData) {

            $date = Carbon::createFromFormat('d/m/Y', $assignmentData['date'])->format('d/m/Y');

            $date_type = $assignmentData['date_type'];

            if ($date_type === 'hijri') {
                $date = Helper::getCoptic($date);
                $date_type = 'coptic';
            }

            DistribtionAssignmentMonitor::create(
                [
                    'md_assignment_id' =>  $assignment->id,
                    'employee_id' => $assignmentData['employee_id'],
                    'date' => $date,
                    'date_type' => $date_type,
                    'period' => json_encode($assignmentData['period'])
                ]
            );
        }
        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(School $school, DistributionAssignment $assignment)
    {
        if ($assignment->school_id == $school->id) {
            $assignment->delete();
        }

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
}
