<?php

namespace App\Http\Controllers\Api\ManagerDashboard\ClassRoomVisit;

use Alkoumi\LaravelHijriDate\Hijri;
use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\ClassRoomVisit\StoreVisitRateRequest;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitCard;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassRoomVisitSession;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitNeed;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitRate;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitRecommendation;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Carbon\Carbon;
use DateTime;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ClassVisitRateController extends Controller
{
    use NamazegTrait;
    /**
     * Handle the incoming request.
     */
    public function __invoke(ClassRoomVisitSession $classRoomVisit, StoreVisitRateRequest $request)
    {
        // Start a transaction
        DB::beginTransaction();
        try {
            $namozeg = Namazeg::where('form_number', 273)->firstOrFail();

        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'Namozeg 273 Not Found for this Class Visit  in namazeg table .'], 404);
        }
        $rate_namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $classRoomVisit->school_id
        );

        try {
            $validated = $request->validated();

            // Convert visit_method_ids array into a comma-separated string
            $validated['data']['class_visit_card']['visit_method_ids'] = implode(',', $validated['data']['class_visit_card']['visit_method_ids']);

            $direct_school_date = $validated['data']['class_visit_card']['direct_school_date'];
            $direct_school_date_type  = $validated['data']['class_visit_card']['direct_school_date_type'];

            if ($direct_school_date_type === 'hijri') {

                $date = Helper::getCoptic($direct_school_date);

                $date_type = 'coptic';

                $validated['data']['class_visit_card']['direct_school_date'] = $date;

                $validated['data']['class_visit_card']['direct_school_date_type'] = $date_type;
           }

            // Store class visit rate
            ClassVisitCard::updateOrCreate(
                ['classVisit_id' => $classRoomVisit->id],
                $validated['data']['class_visit_card']
            );

            // Store class visit rate
            if (isset($validated['data']['class_visit_rate']['school_class_id'])) {
                $classRoomVisit->update(['school_class_id' => $validated['data']['class_visit_rate']['school_class_id']]);
                unset($validated['data']['class_visit_rate']['school_class_id']);
            }
            if (isset($validated['data']['class_visit_rate']['period_id'])) {
                $classRoomVisit->update(['visit_period_id' => $validated['data']['class_visit_rate']['period_id']]);
                unset($validated['data']['class_visit_rate']['period_id']);
            }
            if (isset($validated['data']['class_visit_rate']['subject_id'])) {
                $classRoomVisit->update(['subject_id' => $validated['data']['class_visit_rate']['subject_id']]);
                unset($validated['data']['class_visit_rate']['subject_id']);
            }

            $classRoomVisit->update(['rate_namazeg_version_id'=>$rate_namozeg_version->id]);

            // Store class visit rate
            ClassVisitRate::updateOrCreate(
                ['classVisit_id' => $classRoomVisit->id],
                $validated['data']['class_visit_rate']
            );

            // Store class visit recommendation
            ClassVisitRecommendation::updateOrCreate(
                ['classVisit_id' => $classRoomVisit->id],
                $validated['data']['class_visit_recommendation']
            );

            // Store class visit needs
            foreach ($validated['data']['class_visit_need'] as $need) {
                ClassVisitNeed::updateOrCreate(
                    ['classVisit_id' => $classRoomVisit->id, 'need' => $need['need']],
                    ['recommended' => $need['recommended']]
                );
            }

            // Update visit status after store rate to be completed
            $classRoomVisit->update(['visit_status' => 'complete']);

            // If everything is successful, commit the transaction
            DB::commit();

            return response()->json(['message' => trans('api.record stored successfully')], 200);
        } catch (\Exception $e) {
            // If there is any error, rollback the transaction
            DB::rollBack();

            // Optionally, log the error or return a specific message
            return response()->json(['error' => 'Something went wrong. Please try again.'], 500);
        }
    }
}
