<?php

namespace App\Http\Controllers\Api\ManagerDashboard\ClassRoomVisit;

use App\Helpers\Helper;
use App\Helpers\HelperNotification;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\ClassRoomVisit\StoreClassRoomVisitRequest;
use App\Http\Requests\ManagerDashboard\ClassRoomVisit\UpdateClassRoomVisitRequest;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassRoomvisitResource;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassvisitCardResource;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassVisitNeedResource;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassVisitRateResource;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\ClassVisitRecommendationResource;
use App\Http\Resources\ManagerDashboard\ClassRoomVisit\VisitMethodResource;
use App\Models\AdminDashboard\School\Period;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassRoomVisitSession;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitCard;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitNeed;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitRate;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitRecommendation;
use App\Models\ManagerDashboard\ClassRoomVisits\VisitMethod;
use App\Models\Namazeg;
use App\Traits\LogsActivity;
use App\Traits\NamazegTrait;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Models\AdminDashboard\School\SchoolEmployee;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class ClassRoomVisitController extends Controller
{
    use LogsActivity;
    use NamazegTrait;
    /**
     * Display a listing of the resource.
     */
    public function index(School $school)
    {

        // Get all semesters with status '1'
        $semesters = SchoolSemester::where('status', '1')->get();

        $response = $semesters->map(function ($semester) use ($school) {
            // Get the first ClassRoomVisitSession with a distinct namazeg_version_id
            $classRoomVisitSession = ClassRoomVisitSession::with('namozegVersion')
                ->where('school_id', $school->id)
                ->where('semester_id', $semester->id)
                ->distinct('namazeg_version_id')
                ->first();

            // Get all ClassRoomVisits for the current semester
            $classRoomVisits = ClassRoomvisitResource::collection(
                ClassRoomVisitSession::where('school_id', $school->id)
                    ->where('semester_id', $semester->id)
                    ->get()
            );

            // Return the response data
            return [
                'school_id' => $school->id,
                'semester_id' => $semester->id,
                'semester_name' => $semester->name,
                'serial_number' => $classRoomVisitSession?->namozegVersion?->serial_number,  // Safely get the serial number
                'ClassRoomVisits' => $classRoomVisits,
            ];
        })->values()->all(); // Ensure the response is returned as an array

        return response()->json(['data' => $response], 200);
    }
    /**
     * Display the specified resource.
     */
    public function getSemester(School $school, SchoolSemester $semester)
    {
        $ClassRoomVisits = ClassRoomvisitResource::collection(ClassRoomVisitSession::where('school_id', $school->id)->where('semester_id', $semester->id)->get());

        $school_manager = SchoolEmployee::select('id', 'name')
            ->where('school_id', $school->id)
            ->where('current_work_id', 1)
            ->first();

        return response()->json(['ClassRoomVisits' => $ClassRoomVisits, 'school_manager' => $school_manager], 200);
    }
    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreClassRoomVisitRequest $request)
    {
        $data = $request->validated();

        try {
            $namozeg = Namazeg::where('form_number', 202)->firstOrFail();
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'Namozeg Not Found for this committee form number in namazeg table .'], 404);
        }

        // Check if a NamazegVersion already exists for the school and namozeg_id

        $existing_version = ClassRoomVisitSession::where('semester_id', $request->semester_id)
            ->where('school_id', $request->school_id)
            ->first();

        if ($existing_version) {
            // إذا كان هناك سجل موجود مع namazeg_version_id، نقوم بإضافة سجل جديد بنفس البيانات
            $namozeg_version = $existing_version->namazeg_version_id;
        } else {
            // إذا لم يكن هناك سجل، نقوم بإنشاء namazeg_version_id جديد
            $namozeg_version = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $request->school_id
            )->id;  // تأكد من أن الطريقة storeNamazegVersion ترجع النسخة الجديدة
        }


        $date = Carbon::createFromFormat('d/m/Y', $data['date'])->format('d/m/Y');

        $date_type = $data['date_type'];

        if ($date_type === 'hijri') {

            $date = Helper::getCoptic($date);

            $date_type = 'coptic';
            $data['date'] = $date;
            $data['date_type'] = $date_type;
        }

        $classRoomVisit = new ClassRoomVisitSession();
        $classRoomVisit->fill($data);
        $classRoomVisit->namazeg_version_id = $namozeg_version;
        $classRoomVisit->save();

        // زيارى صفيه اليوم
        HelperNotification::create_class_visits_notifications($classRoomVisit);

        // ------------------------------- School ID -----------------------
        $school_id = $request->school_id;
        $this->ManagerlogActivity('ClassRoomVisitSession', 'store', $school_id, $namozeg->form_number);
        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }

    public function getPeriods()
    {
        $periods = Period::select('id', 'name')->get();
        return response()->json(['periods' => $periods], 200);
    }

    public static function getClassNumber($schoolId, $id)
    {

        $class = SchoolClass::where('class_name_id', $id)->first();

        if (!$class) {
            return response()->json(['error' => 'Class not found'], 404);
        }

        $classNumbers = SchoolClass::select('id', 'class_number')
            ->where('school_id', $schoolId)->where('class_name_id', $class->class_name_id) // Corrected to use class_name_id
            ->get();

        return response()->json(['classNumbers' => $classNumbers], 200);
    }


    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateClassRoomVisitRequest $request, ClassRoomVisitSession $classRoomVisit)
    {
        $data = $request->validated();

        if (isset($data['date'])) {
            $data['date'] = \Carbon\Carbon::createFromFormat('d/m/Y', $data['date'])->format('d/m/Y');
        }

        $classRoomVisit->update($data);
        // ------------------------------- School ID -----------------------
        $school_id = $classRoomVisit->school_id;
        $form_number = $classRoomVisit->namozegVersion->namozeg->form_number;
        $this->ManagerlogActivity('ClassRoomVisitSession', 'update', $school_id, $form_number);
        return response()->json(['message' => trans('api.record updated successfully')], 200);
    }
    /**
     * soft Delete the specified resource from storage.
     */
    public function archive(ClassRoomVisitSession $classRoomVisit)
    {
        $school_id = $classRoomVisit->school_id;
        $classRoomVisit->delete();
        $form_number = $classRoomVisit->namozegVersion->namozeg->form_number;
        $this->ManagerlogActivity('ClassRoomVisitSession', 'archived', $school_id, $form_number);
        return response()->json(['message' => trans('api.record archived successflly')], 200);
    }
    /**
     * restore the specified resource from storage.
     */
    public function restore(ClassRoomVisitSession $classRoomVisit)
    {
        $school_id = $classRoomVisit->school_id;
        $classRoomVisit->restore();
        $form_number = $classRoomVisit->namozegVersion->namozeg->form_number;
        $this->ManagerlogActivity('ClassRoomVisitSession', 'restore', $school_id, $form_number);
        return response()->json(['message' => trans('api.record restored successflly')], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ClassRoomVisitSession $classRoomVisit)
    {
        $school_id = $classRoomVisit->school_id;
        $classRoomVisit->forceDelete();
        $form_number = $classRoomVisit->namozegVersion->namozeg->form_number;
        $this->ManagerlogActivity('ClassRoomVisitSession', 'delete', $school_id, $form_number);
        return response()->json(['message' => trans('api.record deleted successflly')], 200);
    }


    // for get class visit rate

    public function getRating(ClassRoomVisitSession $classRoomVisit)
    {
        // Retrieve the class visit card
        $classVisitCard = ClassVisitCard::where('classVisit_id', $classRoomVisit->id)->first();
        // Retrieve the class visit rate
        $classVisitRate = ClassVisitRate::where('classVisit_id', $classRoomVisit->id)->first();

        // Retrieve the class visit recommendation
        $classVisitRecommendation = ClassVisitRecommendation::where('classVisit_id', $classRoomVisit->id)->first();

        // Retrieve the class visit needs
        $classVisitNeeds = ClassVisitNeed::where('classVisit_id', $classRoomVisit->id)->get();

        if ($classVisitCard) {
            return response()->json([
                'class_visit_card' =>  new ClassvisitCardResource($classVisitCard),
                'class_visit_rate' => new ClassVisitRateResource($classVisitRate),
                'class_visit_recommendation' => new ClassVisitRecommendationResource($classVisitRecommendation),
                'class_visit_needs' =>  ClassVisitNeedResource::collection($classVisitNeeds),
            ]);
        } else {
            return response()->json([]);
        }
    }

    public function getVisitMethods()
    {
        $visitMethods = VisitMethodResource::collection(VisitMethod::get());
        return response()->json(['visitMethods' => $visitMethods], 200);
    }

    public function getManagersAndAgents(School $school)
    {
        $managersAndAgents =  SchoolEmployee::where('school_id', $school->id)
            ->whereIn('current_work_id', [1, 6, 7, 8])
            ->select('id', 'name')->get();
        return response()->json(['managersAndAgents' => $managersAndAgents]);
    }

    public function getNationalities()
    {
        $nationalities =  DB::table('nationalities')
        ->select('id','name')
        ->where('status',true)
        ->get();
        return response()->json(['nationalities' => $nationalities]);
    }
}
