<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Circulars;

use App\Helpers\Helper;
use App\Helpers\HelperNotification;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Circulars\StudentGeneralCircularRequest;
use App\Http\Resources\ManagerDashboard\Circulars\StudentGeneralCircularResource;
use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\Circulars\StudentGeneralCircular;
use App\Models\ManagerDashboard\Circulars\StudentGeneralCircularStudent;
use App\Models\Namazeg;
use App\Traits\LogsActivity;
use App\Traits\NamazegTrait;
use Illuminate\Http\Request;
use Psr\Log\LoggerTrait;

class StudentGeneralCircularController extends Controller
{
    use LogsActivity,NamazegTrait;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        // $this->middleware(['auth:api', 'jwt.verify','permission:internal_circulars']);
    }
    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request){
        // Start with the base query
        $data = StudentGeneralCircular::query();

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Circulars\StudentGeneralCircular', $queryParams);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = StudentGeneralCircularResource::collection($data->paginate($perPage));

        return response()->json([
            'student_general_circulars' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById(StudentGeneralCircular $student_general_circular){
        $student_general_circular = new StudentGeneralCircularResource($student_general_circular);
        return response()->json(['student_general_circular'=>$student_general_circular,'message'=>trans('api.general student circulars details')],200);
    }

    /* this method will stord data to DB Model*/
    public function store(StudentGeneralCircularRequest $request){
        $namozeg = Namazeg::where('form_number', 226)->first();
        $namozeg_version_id = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $request->school_id
        )->id;

        $student_general_circular = StudentGeneralCircular::create([
            'school_id' => $request->school_id,
            'namazeg_version_id' => $namozeg_version_id,
            'title' => $request->title,
            'directed_to' => $request->directed_to,
            'class_name_id' => $request->class_name_id,
            'class_number' => $request->class_number,
        ]);

        switch ($request->directed_to) {
            case 'class_name_and_number':
                $students = Student::join('school_classes as sc','sc.id','school_students.class_id')
                        ->where('sc.school_id',$request->school_id)
                        ->where('school_students.school_id',$request->school_id)
                        ->where('sc.class_name_id',$request->class_name_id)
                        ->where('sc.class_number',$request->class_number)
                        ->pluck('school_students.id')
                        ->toArray();
                break;
            
            case 'class_name':
                $students = Student::join('school_classes as sc','sc.id','school_students.class_id')
                        ->where('sc.school_id',$request->school_id)
                        ->where('school_students.school_id',$request->school_id)
                        ->where('sc.class_name_id',$request->class_name_id)
                        ->pluck('school_students.id')
                        ->toArray();
                break;

            case 'all':
                $students = Student::where('school_id',$request->school_id)->pluck('id')->toArray();
                break;

            default:
                return response()->json(['message'=>trans('api.not valid directed_to value')],404);
                break;
        }

        foreach ($students as $student) {
            StudentGeneralCircularStudent::create([
                'student_general_circular_id' => $student_general_circular->id,
                'student_id' => $student,
            ]);
        }
        HelperNotification::create_Circulars_notifications($request->school_id);
        // ------------------------------- School ID -----------------------
        $school_id = $request->school_id;
        $this->ManagerlogActivity('StudentGeneralCircular', 'store', $school_id);

        return response()->json(['message'=>trans('api.record stored successflly')],200);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(StudentGeneralCircularRequest $request,StudentGeneralCircular $student_general_circular)
    {
        $student_general_circular->update([
            'school_id' => $request->school_id,
            'title' => $request->title,
            'directed_to' => $request->directed_to,
            'class_name_id' => $request->class_name_id,
            'class_number' => $request->class_number,
        ]);

        switch ($request->directed_to) {
            case 'class_name_and_number':
                $students = Student::join('school_classes as sc','sc.id','school_students.class_id')
                        ->where('sc.school_id',$request->school_id)
                        ->where('school_students.school_id',$request->school_id)
                        ->where('sc.class_name_id',$request->class_name_id)
                        ->where('sc.class_number',$request->class_number)
                        ->pluck('school_students.id')
                        ->toArray();
                break;
            
            case 'class_name':
                $students = Student::join('school_classes as sc','sc.id','school_students.class_id')
                        ->where('sc.school_id',$request->school_id)
                        ->where('school_students.school_id',$request->school_id)
                        ->where('sc.class_name_id',$request->class_name_id)
                        ->pluck('school_students.id')
                        ->toArray();
                break;

            case 'all':
                $students = Student::where('school_id',$request->school_id)->pluck('id')->toArray();
                break;

            default:
                return response()->json(['message'=>trans('api.not valid directed_to value')],404);
                break;
        }

        StudentGeneralCircularStudent::where('student_general_circular_id',$student_general_circular->id)->forceDelete();
        foreach ($students as $student) {
            StudentGeneralCircularStudent::create([
                'student_general_circular_id' => $student_general_circular->id,
                'student_id' => $student,
            ]);
        }
        // ------------------------------- School ID -----------------------
        $school_id = $student_general_circular->school_id;
        $this->ManagerlogActivity('StudentGeneralCircular', 'store', $school_id);


        return response()->json(['message'=>trans('api.record updated successflly')],200);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive(StudentGeneralCircular $student_general_circular){
        $school_id = $student_general_circular->school_id;
        $student_general_circular->delete();
        $this->ManagerlogActivity('StudentGeneralCircular', 'archive', $school_id);

        return response()->json(['message'=>trans('api.record archived successflly')],200);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function destroy(StudentGeneralCircular $student_general_circular){
        $school_id = $student_general_circular->school_id;
        $student_general_circular->forceDelete();
        $this->ManagerlogActivity('StudentGeneralCircular', 'delete', $school_id);
        return response()->json(['message'=>trans('api.record deleted successflly')],200);
    }
    
    /* this method will restore specific Model recored 
    by using ID
    */
    public function restore(StudentGeneralCircular $student_general_circular){
        $school_id = $student_general_circular->school_id;
        $student_general_circular->restore();
        $this->ManagerlogActivity('StudentGeneralCircular', 'restore', $school_id);
        return response()->json(['message'=>trans('api.record restored successflly')],200);
    }
}