<?php
namespace App\Http\Controllers\Api\AdminDashboard\Violation;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;
use App\Http\Requests\Violation\NamazegStoreRequest;
use App\Http\Requests\Violation\NamazegUpdateRequest;
use App\Models\Namazeg;
use App\Http\Resources\Violation\NamazegResource;
use App\Models\GradeViolation;
use App\Models\ViolationPunishment;
use App\Traits\LogsActivity;

class NamazegController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        // $this->middleware(['auth:api', 'jwt.verify', 'permission:Namazegs']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request){
        // Start with the base query
        $data = Namazeg::with('category');

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\Namazeg', $queryParams);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = NamazegResource::collection($data->paginate($perPage));

        return response()->json([
            'punshmentOptions' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
        
    }
    public function violation_namazeg(Request $request,GradeViolation $violation_grade){
        $violation_title_ids = $violation_grade->violation_titles?->pluck('id')->toArray();
        $namazeg_ids = ViolationPunishment::whereIn('violation_title_id', $violation_title_ids)->pluck('violation_punishment_id')->toArray();
        $data  = Namazeg::with('category')->where('type','violations')->whereNotIn('id', $namazeg_ids);
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = NamazegResource::collection($data->paginate($perPage));

        return response()->json([
            'punshmentOptions' => $filterData,
            'message' => 'list of all unique records'
        ]);
        
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById($id){
        $violation = Namazeg::findOrFail($id);
        $violation = new NamazegResource($violation);
        return response()->json(['event'=>$violation,'message'=>trans('api.Namazeg details') ]);
    }

    /* this method will stord data to DB Model*/
    public function store(NamazegStoreRequest $request){
        // dd($request->all());
        Namazeg::create($request->all());
        $this->AdminlogActivity('Namazeg', 'store', '/namazegCategories/get-all/');


        return response()->json(['message'=>trans('api.record stored successflly') ]);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(NamazegUpdateRequest $request,$id){
        Namazeg::findOrFail($id)->update($request->all());
        $this->AdminlogActivity('Namazeg', 'update', '/namazegCategories/get-all/');
        return response()->json(['message'=>trans('api.record updated successflly') ]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete($id){
        Namazeg::findOrFail($id)->forceDelete();
        $this->AdminlogActivity('Namazeg', 'delete');

        return response()->json(['message'=>trans('api.record deleted successflly') ]);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive($id)
    {
        Namazeg::findOrFail($id)->delete();
        $this->AdminlogActivity('Namazeg', 'archive');

        return response()->json(['message' => trans('api.record archived successflly')]);
    }


    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore($id)
    {
        Namazeg::withTrashed()->findOrFail($id)->restore();
        $this->AdminlogActivity('Namazeg', 'restore');

        return response()->json(['message' => trans('api.record restored successflly')]);
    }
}