<?php

namespace App\Http\Controllers\Api\AdminDashboard\Slider;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;
use App\Http\Requests\Slider\SliderStoreRequest;
use App\Http\Requests\Slider\SliderUpdateRequest;
use App\Models\Slider;
use App\Http\Resources\Slider\SliderResource;
use App\Traits\LogsActivity;

class SliderController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify', 'permission:sliders']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request)
    {
        // Start with the base query
        $data = Slider::query();

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\Slider', $queryParams);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = SliderResource::collection($data->paginate($perPage));


        return response()->json([
            'sliders' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById($id)
    {
        $slider = Slider::findOrFail($id);
        $slider = new SliderResource($slider);
        return response()->json(['event' => $slider, 'message' => trans('api.slider details')]);
    }

    /* this method will stord data to DB Model*/
    public function store(sliderStoreRequest $request)
    {
        $data = $request->except('image');
        $image_name = Helper::uploadImage('sliders', $request->image);
        $data['image'] = $image_name;

        if ($data['start_date_type'] === 'hijri') {
            $data['start_date'] = Helper::getCoptic($data['start_date']);
            $data['start_date_type'] = 'coptic';
        }
        if ($data['end_date_type'] === 'hijri') {
            $data['end_date'] = Helper::getCoptic($data['end_date']);
            $data['end_date_type'] = 'coptic';
        }

        $slider = Slider::create($data);
        $this->AdminlogActivity('Slider', 'store', '/sliders/' . $slider->id);
        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(SliderUpdateRequest $request, $id)
    {
        $slider = Slider::findOrFail($id);
        $data = $request->except('image');
        if ($request->image) {
            $image_name = Helper::updateUploadedImage('sliders', $request->image, $slider->image);
            $data['image'] = $image_name;
        }

        if (isset($data['start_date_type']) && isset($data['start_date'])) {
            if ($data['start_date_type'] === 'hijri') {
                $data['start_date'] = Helper::getCoptic($data['start_date']);
                $data['start_date_type'] = 'coptic';
            }
        }
        if (isset($data['end_date_type']) && isset($data['end_date'])) {
            if ($data['end_date_type'] === 'hijri') {
                $data['end_date'] = Helper::getCoptic($data['end_date']);
                $data['end_date_type'] = 'coptic';
            }
        }

        $slider->update($data);
        $this->AdminlogActivity('Slider', 'update', '/sliders/' . $id);


        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive($id)
    {
        Slider::findOrFail($id)->delete();
        $this->AdminlogActivity('Slider', 'archive');

        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete($id)
    {
        $slider = Slider::findOrFail($id);
        $path = public_path("uploads/sliders/$slider->image");
        if (file_exists($path)) {
            unlink($path);
        }
        $slider->forceDelete();
        $this->AdminlogActivity('Slider', 'delete');

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }

    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore($id)
    {
        Slider::withTrashed()->findOrFail($id)->restore();
        $this->AdminlogActivity('Slider', 'restore');

        return response()->json(['message' => trans('api.record restored successflly')]);
    }
}
