<?php

namespace App\Http\Controllers\Api\AdminDashboard\Finances;

use App\Http\Controllers\Controller;
use App\Models\AdminDashboard\Finances\SubscriptionDetailsRetrieval;
use App\Models\ManagerDashboard\Settings\Subscription;
use Illuminate\Http\Request;
use App\Helpers\Helper;
class SubscriptionDetailsRetrievalController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, Subscription $subscription)
    {
        $data = $request->validate([
            // 'subscription_id' => ['required', 'exists:subscriptions,id'],
            'approval_number' => ['required', 'numeric'],
            'approval_reason' => ['required', 'string'],
            'receipt_img' => ['nullable', 'mimes:png,jpg,jpeg'],
        ]);

        $data = request()->except('receipt_img');

        $subscriptionDetails = SubscriptionDetailsRetrieval::create([
            'subscription_id' => $subscription->id,
            'approval_number' => $data['approval_number'],
            'approval_reason' => $data['approval_reason'],
        ]);

        if (request()->hasFile('receipt_img')) {
            $fileName = Helper::uploadImage('SubscriptionDetailsRetrieval', request()->file('receipt_img'));
            $subscriptionDetails->receipt_img = $fileName;
            $subscriptionDetails->save();
        }

        $subscription->update([
            'paid_status' => 'refunded'
        ]);

        return response()->json(['message' => "تم الاسترداد بنجاح"], 200);
    }

    /**
     * Display the specified resource.
     */
    public function show(Subscription $subscription)
    {

        $response = $subscription->subscriptionDetailsRetrieval ? [
            'approval_number' => $subscription->subscriptionDetailsRetrieval?->approval_number,
            'approval_reason' => $subscription->subscriptionDetailsRetrieval?->approval_reason,
            'receipt_img' => $subscription->subscriptionDetailsRetrieval?->receipt_img ? url('/uploads/SubscriptionDetailsRetrieval/' . $subscription->subscriptionDetailsRetrieval->receipt_img) : Null
        ] : [];

        return response()->json(['data' => $response], 200);
    }
}
