<?php

namespace App\Factories;

use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegGuidanceCommitteeMeetingRequest;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Assignments\AssignmentCommittee;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegGuidanceCommitteeMeeting;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\CommitteeMember;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Illuminate\Foundation\Http\FormRequest;

class Namozeg161Factory implements NamozegFactory
{
    //  نموذج محضر اجتماع لجنة التوجيه الطلابي بالمدرسة
    use NamazegTrait;
    public function store($school_id, $violation_student_punishment, FormRequest $request)
    {
        $namozeg = Namazeg::where('form_number', '161')->first();
        $student_id = $violation_student_punishment->VStudentTitle->ViolationStudent->student_id;
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $request['v_student_punishment_id'] = $violation_student_punishment->id;
        $request['namazeg_version_id'] = $namozeg_version->id;
        $request['student_id'] = $student_id;

        $destructionProceed = new NamazegGuidanceCommitteeMeetingRequest($request->all());
        $data = $destructionProceed->toArray();
        NamazegGuidanceCommitteeMeeting::create($data);       

        return $namozeg_version;
    }

    public function update($namozeg_version_id, FormRequest $request)
    {
        $incidentProceedRequest = new NamazegGuidanceCommitteeMeetingRequest($request->all());
        $data = $incidentProceedRequest->toArray();
        NamazegGuidanceCommitteeMeeting::where('namazeg_version_id', $namozeg_version_id)->update($data);
        return $namozeg_version_id;
    }


    public function handle($school, $request, $namozeg_version)
    {
        $namazeg_version_id = $namozeg_version->namazeg_version_id ?? $namozeg_version->id;
        $NamazegGuidanceCommitteeMeeting = NamazegGuidanceCommitteeMeeting::with('namozegVersion','student', )->where('namazeg_version_id', $namazeg_version_id)->firstOrFail();
        $school = $NamazegGuidanceCommitteeMeeting->student->school;
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
        $commite = Committee::with('members')->where('assignment_form_number', 33)->firstOrFail();
        $assignment = AssignmentCommittee::where('school_id', $school->id)
            ->where('committee_id', $commite->id)->firstOrFail();
        $members = CommitteeMember::with('employee')->where('assignment_committee_id', $assignment->id)->get();
        
        return [
            'form_number' => $NamazegGuidanceCommitteeMeeting->namozegVersion->namozeg->form_number,
            'serial_number' => $NamazegGuidanceCommitteeMeeting->namozegVersion->serial_number,
            'descions'=>$NamazegGuidanceCommitteeMeeting->descions,
            'manager_name' => $manager_name,
            'members' => $members->map(function ($member) {
                return [
                    'employee_id' => $member->employee_id,
                    'employee_name' => $member->employee->name,
                    'assignment_work' => $member->assignment_work,
                    'current_work' => $member->employee->currentWork?->job_title,
                ];
            }),        
        ];
    }
}
