<?php

namespace App\Factories;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\Assignments\CommitteeAssignmentResource;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegDestructionProceed;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;

class Namozeg157Factory implements NamozegFactory
{
    // فمحضر اتلا
    use NamazegTrait;
    public function store($school_id, $violation_student_punishment, FormRequest $request)
    {
        $namozeg = Namazeg::where('form_number', '157')->first();
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $request['v_student_punishment_id'] = $violation_student_punishment->id;
        $request['namazeg_version_id'] = $namozeg_version->id;
        $data = $request->all();
        if ($data['meeting_date_type'] == 'hijri') {
            $data['meeting_date'] = Helper::getCoptic($data['meeting_date']);
        }
        if ($data['destruction_date_type'] == 'hijri') {
            $data['destruction_date'] = Helper::getCoptic($data['destruction_date']);
        }
        if ($data['invention_date_type'] == 'hijri') {
            $data['invention_date'] = Helper::getCoptic($data['invention_date']);
        }
        unset($data['meeting_date_type'], $data['destruction_date_type'], $data['invention_date_type']);
        NamazegDestructionProceed::create($data);
        return $namozeg_version;
    }

    public function update($namozeg_version_id, FormRequest $request)
    {
        $data = $request->all();
        if ($data['meeting_date_type'] == 'hijri') {
            $data['meeting_date'] = Helper::getCoptic($data['meeting_date']);
        }
        if ($data['destruction_date_type'] == 'hijri') {
            $data['destruction_date'] = Helper::getCoptic($data['destruction_date']);
        }
        if ($data['invention_date_type'] == 'hijri') {
            $data['invention_date'] = Helper::getCoptic($data['invention_date']);
        }
        unset($data['meeting_date_type'], $data['destruction_date_type'], $data['invention_date_type']);
        NamazegDestructionProceed::where('namazeg_version_id', $namozeg_version_id)->update($data);
        return $namozeg_version_id;
    }


    public function handle($school, $request, $namozeg_version)
    {
        $namazeg_version_id = $namozeg_version->namazeg_version_id ?? $namozeg_version->id;
        $NamazegDestructionProceed = NamazegDestructionProceed::with('namozegVersion', 'VStudentPunishment')->where('namazeg_version_id', $namazeg_version_id)->firstOrFail();
        $school_id = $NamazegDestructionProceed->VStudentPunishment->VStudentTitle->ViolationStudent->school_id;
        $committee = Committee::where(function ($query) use ($school) {
            $query->whereNull('school_id') // Default committees
                ->where('id', 2) // Filter by ID
                ->orWhere('school_id', $school->id); // Specific school committees
        })
            ->with([
                'assignment' => function ($query) use ($school) {
                    $query->where('school_id', $school->id); // Filter assignments for the school
                },
                'meetings' => function ($query) use ($school) {
                    $query->where('school_id', $school->id); // Filter meetings for the school
                }
            ])
            ->first();

        $members  = $committee->members
            ? $committee->members->filter(function ($member) use ($committee) {
                return $member->assignment_committee_id == $committee->assignment->id;
            })->map(function ($member) {

                return [
                    'employee_id' => $member->employee_id,
                    'employee_name' => $member->employee->name,
                    'assignment_work' => $member->assignment_work,
                    'current_work' => $member->employee->currentWork?->job_title,
                ];
            })->values() // Reset the keys here
            : [];
        $manager_name = SchoolEmployee::where('school_id', $school_id)->where('current_work_id', 1)->first()?->name;
        return [
            'form_number' => $NamazegDestructionProceed->namozegVersion->namozeg->form_number,
            'serial_number' => $NamazegDestructionProceed->namozegVersion->serial_number,
            'destruction_day' =>   Carbon::createFromFormat('d/m/Y', $NamazegDestructionProceed->destruction_date)->translatedFormat('D', 'ar'),
            'destruction_date_option' => Helper::getDateOptions($NamazegDestructionProceed->destruction_date, 'coptic'),
            'crime_time' => $NamazegDestructionProceed->crime_time,
            'student_name' => $NamazegDestructionProceed->VStudentPunishment->VStudentTitle->ViolationStudent->student->name,
            'schoolClass' => $NamazegDestructionProceed->VStudentPunishment->VStudentTitle->ViolationStudent->student->schoolClass->className->name,
            'invention_day' =>   Carbon::createFromFormat('d/m/Y', $NamazegDestructionProceed->invention_date)->translatedFormat('D', 'ar'),
            'invention_date_option' => Helper::getDateOptions($NamazegDestructionProceed->invention_date, 'coptic'),
            'violation_grade_name' => $NamazegDestructionProceed->VStudentPunishment->VStudentTitle->ViolationStudent->violationGrade->name,
            'details' => $NamazegDestructionProceed->details,
            'decision_number' => $NamazegDestructionProceed->decision_number,
            'meeting_day' =>   Carbon::createFromFormat('d/m/Y', $NamazegDestructionProceed->meeting_date)->translatedFormat('D', 'ar'),
            'meeting_date_option' => Helper::getDateOptions($NamazegDestructionProceed->meeting_date, 'coptic'),
            'manager_name' => $manager_name,
            'committeesAssignments' => $members,

        ];
    }
}
