<?php

namespace App\Factories;

use App\Helpers\Helper;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegFatherNotiyStudentMoveRequest;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegFatherNotiyStudentMove;
use App\Models\ManagerDashboard\Namazeg\Violations\StudentViolationDegrees;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use App\Models\Namazeg;
use App\Models\ViolationPunishment;
use App\Traits\NamazegTrait;
use Illuminate\Foundation\Http\FormRequest;

class Namozeg151Factory implements NamozegFactory
{
    //  نموذج إشعار ولي الأمر بنقل الطالب من المدرسة
    use NamazegTrait;
    public function store($school_id, $violation_student_punishment, FormRequest $request)
    {
        $namozeg = Namazeg::where('form_number', '151')->first();
        $student_id = $violation_student_punishment->VStudentTitle->ViolationStudent->student_id;
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $request['v_student_punishment_id'] = $violation_student_punishment->id;
        $request['namazeg_version_id'] = $namozeg_version->id;
        $request['student_id'] = $student_id;

        $destructionProceed = new NamazegFatherNotiyStudentMoveRequest($request->all());
        $data = $destructionProceed->toArray();
        $data['study_year'] = "old";
        NamazegFatherNotiyStudentMove::create($data);


        return $namozeg_version;
    }

    public function update($namozeg_version_id, FormRequest $request)
    {
        $incidentProceedRequest = new NamazegFatherNotiyStudentMoveRequest($request->all());
        $data = $incidentProceedRequest->toArray();
        NamazegFatherNotiyStudentMove::where('namazeg_version_id', $namozeg_version_id)->update($data);
        return $namozeg_version_id;
    }


    public function handle($school, $request, $namozeg_version)
    {
        $namazeg_version_id = $namozeg_version->namazeg_version_id ?? $namozeg_version->id;
        $violation_student_punishment = ViolationStudentPunishment::with('VStudentTitle')->where('namazeg_version_id', $namazeg_version_id)->first();
        $violation_grade = $violation_student_punishment->VStudentTitle->ViolationStudent->violationGrade;

        $NamazegFatherNotiyStudentMove = NamazegFatherNotiyStudentMove::with('namozegVersion', 'student')->where('namazeg_version_id', $namazeg_version_id)->firstOrFail();
        $school = $NamazegFatherNotiyStudentMove->student->school;
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;

        return [
            'form_number' => $NamazegFatherNotiyStudentMove->namozegVersion->namozeg->form_number,
            'serial_number' => $NamazegFatherNotiyStudentMove->namozegVersion->serial_number,
            'student_name' => $NamazegFatherNotiyStudentMove->student->name,
            'school_class' => $NamazegFatherNotiyStudentMove->student->schoolClass->className->name,
            'violation_grade_name' => $violation_grade->name,
            // 'study_year' => $NamazegFatherNotiyStudentMove->study_year,
            'study_year' => $school->current_school_year,
            'new_class' => $NamazegFatherNotiyStudentMove->new_semester->name,
            'education_department' => $school->educationDepartment?->name,
            'manager_name' => $manager_name,

        ];
    }
}
