<?php

namespace App\Factories;

use App\Helpers\Helper;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegMinusStudentDescionRequest;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\BasicRelativePunishment;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegMinusStudentDescion;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegMinusStudentDescionWitness;
use App\Models\ManagerDashboard\Namazeg\Violations\StudentViolationDegrees;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use App\Models\ManagerDashboard\Violations\ViolationStudentTitle;
use App\Models\Namazeg;
use App\Models\ViolationPunishment;
use App\Traits\NamazegTrait;
use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;

class Namozeg149Factory implements NamozegFactory
{
    //  اشعار حسم
    use NamazegTrait;
    public function store($school_id, $violation_student_punishment, FormRequest $request)
    {
        $punishment_value = ViolationPunishment::where('violation_title_id', $violation_student_punishment->VStudentTitle->violation_title_id)
            ->where('violation_punishment_id', $violation_student_punishment->punishment_id)->first();
        $punishment_value = $punishment_value ? $punishment_value->value : 5;

        $namozeg = Namazeg::where('form_number', '149')->first();
        $student_id = $violation_student_punishment->VStudentTitle->ViolationStudent->student_id;


        $violation_grade = $violation_student_punishment->VStudentTitle->ViolationStudent->violationGrade;
        $violation_category = $violation_grade->violation_category;
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $request['v_student_punishment_id'] = $violation_student_punishment->id;
        $request['namazeg_version_id'] = $namozeg_version->id;
        $request['student_id'] = $student_id;

        $destructionProceed = new NamazegMinusStudentDescionRequest($request->all());
        $data = $destructionProceed->toArray();
        if ($data['date_type'] == 'hijri') {
            $data['date'] = Helper::getCoptic($data['date']);
        }
        unset($data['date_type']);
        NamazegMinusStudentDescion::create($data);
        StudentViolationDegrees::create([
            'violation_category_id' => $violation_category->id,
            'violation_grade_id' => $violation_grade->id,
            'namazeg_version_id' => $namozeg_version->id,
            'student_id' => $student_id,
            'bad_value' => $punishment_value,
        ]);

        return $namozeg_version;
    }

    public function update($namozeg_version_id, FormRequest $request)
    {
        $incidentProceedRequest = new NamazegMinusStudentDescionRequest($request->all());
        $data = $incidentProceedRequest->toArray();
        if ($data['date_type'] == 'hijri') {
            $data['date'] = Helper::getCoptic($data['date']);
        }
        unset($data['date_type']);
        NamazegMinusStudentDescion::where('namazeg_version_id', $namozeg_version_id)->update($data);
        return $namozeg_version_id;
    }


    public function handle($school, $request, $namozeg_version)
    {
        $namazeg_version_id = $namozeg_version->namazeg_version_id ?? $namozeg_version->id;
        $violation_student_punishment = ViolationStudentPunishment::with('VStudentTitle')->where('namazeg_version_id', $namazeg_version_id)->first();
        $violation_grade = $violation_student_punishment->VStudentTitle->ViolationStudent->violationGrade;
        $violation_type = $violation_student_punishment->VStudentTitle->ViolationStudent->type;

        $namazegMinusStudentDescion = NamazegMinusStudentDescion::with('degree', 'namozegVersion', 'student')->where('namazeg_version_id', $namazeg_version_id)->firstOrFail();
        $school = $namazegMinusStudentDescion->student->school;
        $grade_name = $school->schoolGrade->name;
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;

        return [
            'form_number' => $namazegMinusStudentDescion->namozegVersion->namozeg->form_number,
            'serial_number' => $namazegMinusStudentDescion->namozegVersion->serial_number,
            'student_name' => $namazegMinusStudentDescion->student->name,
            'schoolClass' => $namazegMinusStudentDescion->student->schoolClass->className->name,
            'current_semester' => Helper::getCurrentSchoolSemester()?->name,
            'grade_name' => $grade_name,
            'violation_grade_name' => $violation_grade->name,
            'violation_type' => $violation_type ? $violation_type->name : $violation_student_punishment->VStudentTitle->ViolationStudent->other_type,
            'date_option' => Helper::getDateOptions($namazegMinusStudentDescion->date, 'coptic'),
            'value' => $namazegMinusStudentDescion->degree->bad_value,
            'current_school_year' => $school->current_school_year,
            'return_condition' => $namazegMinusStudentDescion->return_condition,
            'manager_name' => $manager_name,
            'descion_number' => $namazegMinusStudentDescion->descion_number,

        ];
    }
}
