<?php

namespace App\Factories;

use App\Helpers\Helper;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegFatherNotifyRequest;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegFatherNotify;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Illuminate\Foundation\Http\FormRequest;

class Namozeg147Factory implements NamozegFactory
{
    //  نموذج إشعار ولي أمر الطالب 
    use NamazegTrait;
    public function store($school_id, $violation_student_punishment, FormRequest $request)
    {
        $namozeg = Namazeg::where('form_number', '147')->first();
        $student_id = $violation_student_punishment->VStudentTitle->ViolationStudent->student_id;
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $request['v_student_punishment_id'] = $violation_student_punishment->id;
        $request['namazeg_version_id'] = $namozeg_version->id;
        $request['student_id'] = $student_id;

        $destructionProceed = new NamazegFatherNotifyRequest($request->all());
        $data = $destructionProceed->toArray();
        NamazegFatherNotify::create($data);

        return $namozeg_version;
    }

    public function update($namozeg_version_id, FormRequest $request)
    {
        $incidentProceedRequest = new NamazegFatherNotifyRequest($request->all());
        $data = $incidentProceedRequest->toArray();
        NamazegFatherNotify::where('namazeg_version_id', $namozeg_version_id)->update($data);
        return $namozeg_version_id;
    }


    public function handle($school, $request, $namozeg_version)
    {
        $namazeg_version_id = $namozeg_version->namazeg_version_id ?? $namozeg_version->id;
        $violation_student_punishment = ViolationStudentPunishment::with('VStudentTitle')->where('namazeg_version_id', $namazeg_version_id)->first();
        $violation_grade = $violation_student_punishment->VStudentTitle->ViolationStudent->violationGrade;
        $violation_type = $violation_student_punishment->VStudentTitle->ViolationStudent->type;
        $NamazegFatherNotify = NamazegFatherNotify::with( 'namozegVersion', 'student')->where('namazeg_version_id', $namazeg_version_id)->firstOrFail();
        $school = $NamazegFatherNotify->student->school;
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;

        return [
            'form_number' => $NamazegFatherNotify->namozegVersion->namozeg->form_number,
            'serial_number' => $NamazegFatherNotify->namozegVersion->serial_number,
            'student_name' => $NamazegFatherNotify->student->name,
            'schoolClass' => $NamazegFatherNotify->student->schoolClass->className->name,
            'violation_grade_name' => $violation_grade->name,
            'violation_type' => $violation_type ? $violation_type->name : $violation_student_punishment->VStudentTitle->ViolationStudent->other_type,
            'actions' => $NamazegFatherNotify->actions,
            'manager_name' => $manager_name
        ];
    }
}
