<?php

namespace App\Factories;

use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegIncidentProceedRequest;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegIncidentProceed;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegIncidentProceedWitness;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Illuminate\Foundation\Http\FormRequest;

class Namozeg142Factory implements NamozegFactory
{
    //  محضر ضبط الواقعة
    use NamazegTrait;
    public function store($school_id, $violation_student_punishment, FormRequest $request)
    {
        $namozeg = Namazeg::where('form_number', '142')->first();
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $request['v_student_punishment_id'] = $violation_student_punishment->id;
        $request['namazeg_version_id'] = $namozeg_version->id;
        $request['student_id'] = $violation_student_punishment->VStudentTitle->ViolationStudent->student_id;

        $destructionProceed = new NamazegIncidentProceedRequest($request->all());
        $data = $destructionProceed->toArray();
        unset($data['witnesses']);
        $incident_proceed = NamazegIncidentProceed::create($data);
        foreach ($request->witnesses as $witness) {
            NamazegIncidentProceedWitness::create([
                'namazeg_incident_proceed_id' => $incident_proceed->id,
                'employee_id' => $witness['employee_id'],
                'his_work' => $witness['his_work']
            ]);
        }

        return $namozeg_version;
    }

    public function update($namozeg_version_id, FormRequest $request)
    {
        $incidentProceedRequest = new NamazegIncidentProceedRequest($request->all());
        $data = $incidentProceedRequest->toArray();
        unset($data['witnesses']);
        $incidentProceed = NamazegIncidentProceed::where('namazeg_version_id', $namozeg_version_id)->first();
        $incidentProceed->update($data);
        NamazegIncidentProceedWitness::where('namazeg_incident_proceed_id', $incidentProceed->id)->delete();
        foreach ($request->witnesses as $witness) {
            NamazegIncidentProceedWitness::create([
                'namazeg_incident_proceed_id' => $incidentProceed->id,
                'employee_id' => $witness['employee_id'],
                'his_work' => $witness['his_work']
            ]);
        }

        return $namozeg_version_id;
    }


    public function handle($school, $request, $namozeg_version)
    {
        $namazeg_version_id = $namozeg_version->namazeg_version_id ?? $namozeg_version->id;
        $violation_student_punishment = ViolationStudentPunishment::with('VStudentTitle')->where('namazeg_version_id', $namazeg_version_id)->first();
        $violation_grade = $violation_student_punishment->VStudentTitle->ViolationStudent->violationGrade;
        $violation_type = $violation_student_punishment->VStudentTitle->ViolationStudent->type;

        $NamazegIncidentProceed = NamazegIncidentProceed::with('witnesses', 'namozegVersion', 'student')->where('namazeg_version_id', $namazeg_version_id)->firstOrFail();
        $school = $NamazegIncidentProceed->student->school;
        $grade_name = $school->schoolGrade->name;
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
        $witnesses = $NamazegIncidentProceed->witnesses->map(function ($witness) {
            return [
                'employee_id' => $witness->employee_id,
                'employee_name' => $witness->employee->name,
                'current_work' => $witness->employee->currentWork->job_title,
                'his_work' => $witness->his_work,
            ];
        });

        return [
            'form_number' => $NamazegIncidentProceed->namozegVersion->namozeg->form_number,
            'serial_number' => $NamazegIncidentProceed->namozegVersion->serial_number,
            'student_name' => $NamazegIncidentProceed->student->name,
            'schoolClass' => $NamazegIncidentProceed->student->schoolClass->className->name,
            'grade_name' => $grade_name,
            'violation_type' => $violation_type ? $violation_type->name : $violation_student_punishment->VStudentTitle->ViolationStudent->other_type,
            'violation_grade_name' => $violation_grade->name,
            'type' => $NamazegIncidentProceed->type,
            'other_type' => $NamazegIncidentProceed->other_type,
            'location' => $NamazegIncidentProceed->location,
            'witnesses' => $witnesses,

            'current_school_year' => $school->current_school_year,
            'manager_name' => $manager_name,

        ];
    }
}
