<?php
namespace App\Exports;

use App\Models\AdminDashboard\School\SchoolEmployee;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class SchoolEmployeeExport implements FromQuery, WithHeadings, WithMapping, WithChunkReading, ShouldAutoSize
{
    protected $startDate;
    protected $endDate;
    protected $schoolId;

    public function __construct($startDate = null, $endDate = null,$schoolId)
    {
        $this->startDate = $startDate ? Carbon::createFromFormat('d/m/Y', $startDate)->format('Y-m-d H:i:s') : null;
        $this->endDate = $endDate ? Carbon::createFromFormat('d/m/Y', $endDate)->format('Y-m-d H:i:s') : null;
        $this->schoolId = $schoolId;

    }

    /**
     * Query to fetch data for export with optional date conditions.
     *
     * @return \Illuminate\Database\Query\Builder
     */
    public function query()
    {
        $query = SchoolEmployee::where('school_id', $this->schoolId);
        if (!is_null($this->startDate) && !is_null($this->endDate)) {
            $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
        }
        return $query;
    }

    /**
     * Define the column headings.
     *
     * @return array
     */
    public function headings(): array
    {
        return [
            'ID',
            'Name',
            'Email',
            'Phone',
            'Nationality',
            'School Grade',
            'Class Name',
            'Created At',
            // Add more headings as needed
        ];
    }

    /**
     * Map data for each row.
     *
     * @param $schoolEmployee
     * @return array
     */
    public function map($schoolEmployee): array
    {
        return [
            $schoolEmployee->id,
            $schoolEmployee->name,
            $schoolEmployee->email,
            $schoolEmployee->phone,
            $schoolEmployee->nationality,
            $schoolEmployee->school?->name,
            $schoolEmployee->created_at,
        ];
    }

    /**
     * Define the chunk size for large exports.
     *
     * @return int
     */
    public function chunkSize(): int
    {
        return 1000; // Adjust this based on memory limits
    }
}
