<?php

namespace App\Exports;
use Carbon\Carbon;

use App\Models\AdminDashboard\Coupons\Coupon;
use Maatwebsite\Excel\Concerns\FromCollection;


class CouponsExport implements FromCollection
{
    protected $startDate;
    protected $endDate;

    public function __construct($startDate = null, $endDate = null)
    {
        // Check if the start and end dates are provided and format them using Carbon
        $this->startDate = $startDate ? Carbon::createFromFormat('d/m/Y', $startDate)->format('Y-m-d H:i:s') : null;
        $this->endDate = $endDate ? Carbon::createFromFormat('d/m/Y', $endDate)->format('Y-m-d H:i:s') : null;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
    
     

        // If both startDate and endDate are provided, filter by the date range
        if (!is_null($this->startDate) && !is_null($this->endDate)) {
            return Coupon::whereBetween('created_at', [$this->startDate, $this->endDate])->get();
        }

        // If no date range is provided, return all coupons
        return Coupon::all();
    }
}

