<?php
namespace App\Exports;

use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Settings\Subscription;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class ClientExport implements FromQuery, WithHeadings, WithMapping, WithChunkReading, ShouldAutoSize
{
    protected $startDate;
    protected $endDate;

    public function __construct($startDate = null, $endDate = null)
    {
        $this->startDate = $startDate ? Carbon::createFromFormat('d/m/Y', $startDate)->format('Y-m-d H:i:s') : null;
        $this->endDate = $endDate ? Carbon::createFromFormat('d/m/Y', $endDate)->format('Y-m-d H:i:s') : null;
    }

    /**
     * Query to fetch data for export with optional date conditions.
     *
     * @return \Illuminate\Database\Query\Builder
     */
    public function query()
    {
        $query = Subscription::where('service_type','system')->with(['user', 'school']);

        if (!is_null($this->startDate) && !is_null($this->endDate)) {
            $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
        }

        return $query;
    }

    /**
     * Define the column headings.
     *
     * @return array
     */
    public function headings(): array
    {
        return [
            'م',
            'اسم المستخدم',
            'نوع العميل',
            'اسم المدارس',
            'آخر ظهور',
            'تاريخ الإنضمام',
            'حالة الحساب',
        ];
    }

    /**
     * Map data for each row.
     *
     * @param $client
     * @return array
     */
    public function map($client): array
    {
        $schoolNames = School::where('user_id', $client->user_id)
            ->pluck('name')
            ->toArray();

        $subscription_diff =  (Carbon::createFromFormat('d/m/Y', $client->end_date) > Carbon::now()) ? Carbon::createFromFormat('d/m/Y', $client->end_date)->diffInDays(Carbon::now()) : 0;
        if($subscription_diff <= 30 && $subscription_diff > 0) {
            $endSoon = 'شارف علي انتهاء الإشتراك';
            $clientType = $client->status === 'subscribed' ? 'مشترك' : ($client->status	 === 'Experimental' ? 'تجريبي' : 'غير مشترك') ;
            $clientType = $clientType . ', ' . $endSoon;
        } else {
            $clientType = $client->status === 'subscribed' ? 'مشترك' : ($client->status	 === 'Experimental' ? 'تجريبي' : 'غير مشترك') ;
        }

        return [
            $client->id,
            $client->user->name,
            $clientType ,
            implode(', ', $schoolNames), // Convert array to comma-separated string
            $client->user->getLastSeen(),
            $client?->user?->created_at ? Carbon::parse($client->user->created_at)->format('d/m/Y') : '',
            $client->user->status === 'active' ? 'نشط' : ($client->status === 'canceled' ? 'ملغي' : 'معطل'),
        ];
    }

    /**
     * Define the chunk size for large exports.
     *
     * @return int
     */
    public function chunkSize(): int
    {
        return 1000; // Adjust this based on memory limits
    }
}
