<?php

namespace App\Enums;

enum ReportType: int
{
    case SICK = 1; 
    case ACCOMPANIMENT = 2; 
    case PAPY = 3; 
    case DEATH = 4; 

    public function label(): string
    {
        return match ($this) {
            self::SICK => 'مرضى',
            self::ACCOMPANIMENT => 'مرافقة',
            self::PAPY => 'اجازة مولود',
            self::DEATH => 'وفاة',
        };
    }
}
