<?php

use App\Http\Controllers\Api\AdminDashboard\Procedures\AbsenceProcedureController;
use App\Http\Controllers\Api\AdminDashboard\Procedures\AbsenceProceduresFormController;
use App\Http\Controllers\Api\AdminDashboard\Procedures\LateProcedureController;
use App\Http\Controllers\Api\AdminDashboard\Procedures\LateProceduresFormController;
use Illuminate\Support\Facades\Route;



/* procedures */
Route::group(['prefix' => 'procedures/'], function () {
    
   
    Route::get('names', [AbsenceProcedureController::class, 'procedureNames']);


    /* absenceProceduresForms */
    Route::group(['prefix' => 'absenceProceduresForms/', 'controller' => AbsenceProceduresFormController::class], function () {
        Route::get('get-all', 'getAll');
        Route::post('store', 'store');
        Route::get('{absenceProceduresForm}/details', 'getById');
        Route::get('{absenceProceduresForm}/edit', 'edit');
        Route::post('{absenceProceduresForm}/update', 'update');
        Route::post('{absenceProceduresForm}/changeStatus', 'changeStatus');
        Route::delete('{absenceProceduresForm}/archive', 'archive');
        Route::delete('{absenceProceduresForm}/destroy', 'destroy')->withTrashed();
        Route::get('{absenceProceduresForm}/restore', 'restore')->withTrashed();
    });
    /* AbsenceProcedures */
    Route::group(['prefix' => 'absenceProcedures/', 'controller' => AbsenceProcedureController::class], function () {
        Route::get('get-all', 'getAll');
        Route::get('create', 'create');
        Route::post('store', 'store');
        Route::get('{absenceProcedure}/details', 'getById');
        Route::get('{absenceProcedure}/edit', 'edit');
        Route::post('{absenceProcedure}/update', 'update');
        Route::post('{absenceProcedure}/changeStatus', 'changeStatus');
        Route::delete('{absenceProcedure}/archive', 'archive');
        Route::delete('{absenceProcedure}/destroy', 'destroy')->withTrashed();
        Route::get('{absenceProcedure}/restore', 'restore')->withTrashed();
    });

    /* lateProceduresForms */
    Route::group(['prefix' => 'lateProceduresForms/', 'controller' => LateProceduresFormController::class], function () {
        Route::get('get-all', 'getAll');
        Route::post('store', 'store');
        Route::get('{lateProceduresForm}/details', 'getById');
        Route::get('{lateProceduresForm}/edit', 'edit');
        Route::post('{lateProceduresForm}/update', 'update');
        Route::post('{lateProceduresForm}/changeStatus', 'changeStatus');
        Route::delete('{lateProceduresForm}/archive', 'archive');
        Route::delete('{lateProceduresForm}/destroy', 'destroy')->withTrashed();
        Route::get('{lateProceduresForm}/restore', 'restore')->withTrashed();
    });

    Route::group(['prefix' => 'lateProcedures/', 'controller' => LateProcedureController::class], function () {
        Route::get('get-all', 'getAll');
        Route::get('create', 'create');
        Route::post('store', 'store');
        Route::get('{lateProcedure}/details', 'getById');
        Route::get('{lateProcedure}/edit', 'edit');
        Route::post('{lateProcedure}/update', 'update');
        Route::post('{lateProcedure}/changeStatus', 'changeStatus');
        Route::delete('{lateProcedure}/archive', 'archive');
        Route::delete('{lateProcedure}/destroy', 'destroy')->withTrashed();
        Route::get('{lateProcedure}/restore', 'restore')->withTrashed();
    });
});